<?php
/**
 * user
 * @package EMLOG
 * @link https://www.emlog.net
 */

/**
 * @var string $action
 * @var object $CACHE
 */

require_once 'globals.php';

$memberModel = new Member_Model();

if (empty($action)) {
    $page = Input::getIntVar('page', 1);

    $members = $memberModel->getMembers($page);
    $dataCount = $memberModel->getMemberCount();
    $pageurl = pagination($dataCount, Option::get('admin_article_perpage_num'), $page, "./user.php?page=");


    $br = '<ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="./">控制台</a></li>
        <li class="breadcrumb-item"><a href="user.php">用户管理</a></li>
        <li class="breadcrumb-item active" aria-current="page">会员等级</li>
    </ol>';
    include View::getAdmView('header');
    require_once View::getAdmView('member');
    include View::getAdmView('footer');
    View::output();
}

if ($action == 'add') {

    LoginAuth::checkToken();

    $name = Input::postStrVar('name');

    $memberModel->add($name);

    output::ok();

}

if ($action == 'edit') {
    LoginAuth::checkToken();
    $id = Input::postIntVar('id');
    $name = Input::postStrVar('name');
    $memberModel->edit($id, $name);
    output::ok();
}



if ($action == 'del') {
    LoginAuth::checkToken();
    $id = Input::postIntVar('id');
    $memberModel->del($id);
    output::ok();
}

if ($action == 'forbid') {
    LoginAuth::checkToken();
    $uid = isset($_GET['uid']) ? (int)$_GET['uid'] : '';

    if (UID == $uid) {
        emDirect('./user.php');
    }

    //创始人账户不能被禁用
    if ($uid == 1) {
        emDirect('./user.php');
    }

    $User_Model->forbidUser($uid);
    emDirect('./user.php?active_fb=1');
}

if ($action == 'unforbid') {
    LoginAuth::checkToken();
    $uid = isset($_GET['uid']) ? (int)$_GET['uid'] : '';

    $User_Model->unforbidUser($uid);
    emDirect('./user.php?active_unfb=1');
}
