<?php
/**
 * navbar menu items
 * @package EMLOG
 * @link https://www.emlog.net
 */

/**
 * @var string $action
 * @var object $CACHE
 */

require_once 'globals.php';

$Navi_Model = new Navi_Model();

if (empty($action)) {
    $emPage = new Log_Model();

    $navis = $Navi_Model->getNavis();
    $sorts = $CACHE->readCache('sort');
    $blog_sorts = $CACHE->readCache('blog_sort');
    $pages = $emPage->getAllPageList();


    $br = '<ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="./">控制台</a></li>
        <li class="breadcrumb-item"><a href="./navbar.php">外观设置</a></li>
        <li class="breadcrumb-item active" aria-current="page">导航管理</li>
    </ol>';
    include View::getAdmView('header');
    require_once(View::getAdmView('navbar'));
    include View::getAdmView('footer');
    View::output();
}

if ($action == 'taxis') {
    $navi = isset($_POST['navi']) ? $_POST['navi'] : '';

    if (empty($navi)) {
        Output::error('没有可排序的导航');
    }

    foreach ($navi as $key => $value) {
        $value = (int)$value;
        $key = (int)$key;
        $Navi_Model->updateNavi(array('taxis' => $key), $value);
    }
    $CACHE->updateCache('navi');
    Output::ok();
}

if ($action == 'add') {
    $taxis = isset($_POST['taxis']) ? (int)trim($_POST['taxis']) : 0;
    $naviname = isset($_POST['naviname']) ? addslashes(trim($_POST['naviname'])) : '';
    $url = isset($_POST['url']) ? addslashes(trim($_POST['url'])) : '';
    $pid = isset($_POST['pid']) ? (int)$_POST['pid'] : 0;
    $newtab = isset($_POST['newtab']) ? addslashes(trim($_POST['newtab'])) : 'n';

    if ($naviname == '' || $url == '') {
        emDirect("./navbar.php?error_a=1");
    }

    $Navi_Model->addNavi($naviname, $url, $taxis, $pid, $newtab);
    $CACHE->updateCache('navi');
    emDirect("./navbar.php?active_add=1");
}

if ($action == 'add_sort') {
    $sort_ids = isset($_POST['sort_ids']) ? $_POST['sort_ids'] : array();

    $sorts = $CACHE->readCache('sort');

    if (empty($sort_ids)) {
        emDirect("./navbar.php?error_d=1");
    }

    foreach ($sort_ids as $val) {
        $sort_id = (int)$val;
        $Navi_Model->addNavi(addslashes($sorts[$sort_id]['sortname']), '', 0, 0, 'n', Navi_Model::navitype_sort, $sort_id);
    }

    $CACHE->updateCache('navi');
    emDirect("./navbar.php?active_add=1");
}

if ($action == 'add_blogsort') {
    $sort_ids = isset($_POST['sort_ids']) ? $_POST['sort_ids'] : array();

    $sorts = $CACHE->readCache('blog_sort');

    if (empty($sort_ids)) {
        emDirect("./navbar.php?error_d=1");
    }

    foreach ($sort_ids as $val) {
        $sort_id = (int)$val;
        $Navi_Model->addNavi(addslashes($sorts[$sort_id]['sortname']), '', 0, 0, 'n', Navi_Model::navitype_blogsort, $sort_id);
    }

    $CACHE->updateCache('navi');
    emDirect("./navbar.php?active_add=1");
}

if ($action == 'add_page') {
    $pages = isset($_POST['pages']) ? $_POST['pages'] : array();

    if (empty($pages)) {
        emDirect("./navbar.php?error_e=1");
    }

    foreach ($pages as $id => $title) {
        $id = (int)$id;
        $title = addslashes($title);
        $Navi_Model->addNavi($title, '', 0, 0, 'n', Navi_Model::navitype_page, $id);
    }

    $CACHE->updateCache('navi');
    emDirect('./navbar.php?active_add=1');
}

if ($action == 'mod') {
    $naviId = isset($_GET['navid']) ? (int)$_GET['navid'] : '';
    $navis = $CACHE->readCache('navi');
    $naviData = $Navi_Model->getOneNavi($naviId);
    extract($naviData);
    if ($type != Navi_Model::navitype_custom) {
        $url = '该导航地址由系统生成，无法修改';
    }
    $conf_newtab = $newtab == 'y' ? 'checked="checked"' : '';
    $conf_isdefault = $type != Navi_Model::navitype_custom ? 'disabled="disabled"' : '';

    $br = '<ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="./">控制台</a></li>
        <li class="breadcrumb-item"><a href="./template.php">外观设置</a></li>
        <li class="breadcrumb-item"><a href="./navbar.php">导航管理</a></li>
        <li class="breadcrumb-item active" aria-current="page">修改导航</li>
    </ol>';

    include View::getAdmView('header');
    require_once(View::getAdmView('naviedit'));
    include View::getAdmView('footer');
    View::output();
}

if ($action == 'update') {
    $naviname = isset($_POST['naviname']) ? addslashes(trim($_POST['naviname'])) : '';
    $url = isset($_POST['url']) ? addslashes(trim($_POST['url'])) : '';
    $newtab = isset($_POST['newtab']) ? addslashes(trim($_POST['newtab'])) : 'n';
    $naviId = isset($_POST['navid']) ? (int)$_POST['navid'] : '';
    $isdefault = isset($_POST['isdefault']) ? addslashes(trim($_POST['isdefault'])) : 'n';
    $pid = isset($_POST['pid']) ? (int)trim($_POST['pid']) : 0;

    $navi_data = array(
        'naviname' => $naviname,
        'newtab'   => $newtab,
        'pid'      => $pid,
    );

    if (empty($naviname)) {
        unset($navi_data['naviname']);
    }

    if ($isdefault == 'n') {
        $navi_data['url'] = $url;
    }

    $Navi_Model->updateNavi($navi_data, $naviId);

    $CACHE->updateCache('navi');
    emDirect("./navbar.php?active_edit=1");
}

if ($action == 'del') {
    LoginAuth::checkToken();
    $navid = isset($_GET['id']) ? (int)$_GET['id'] : '';
    $Navi_Model->deleteNavi($navid);
    $CACHE->updateCache('navi');
    emDirect("./navbar.php?active_del=1");
}

if ($action == 'hide') {
    $naviId = isset($_GET['id']) ? (int)$_GET['id'] : '';

    $Navi_Model->updateNavi(array('hide' => 'y'), $naviId);

    $CACHE->updateCache('navi');
    emDirect('./navbar.php');
}

if ($action == 'show') {
    $naviId = isset($_GET['id']) ? (int)$_GET['id'] : '';

    $Navi_Model->updateNavi(array('hide' => 'n'), $naviId);

    $CACHE->updateCache('navi');
    emDirect('./navbar.php');
}
