<?php
/**
 * sort manager
 * @package EMLOG
 * @link https://www.emlog.net
 */

/**
 * @var string $action
 * @var object $CACHE
 */

require_once 'globals.php';

$skuModel = new Sku_Model();

if (empty($action)) {
    $skus = $skuModel->getSkus();


    $br = '<ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="./">控制台</a></li>
        <li class="breadcrumb-item"><a href="./goods.php">商品管理</a></li>
        <li class="breadcrumb-item active" aria-current="page">规格属性</li>
    </ol>';

    include View::getAdmView('header');
    require_once View::getAdmView('sku');
    include View::getAdmView('footer');
    View::output();
}

if($action == 'detail'){
    $type_id = Input::getIntVar('type_id');

    $cate = $skuModel->getCate($type_id);

    $list = $skuModel->getDetail($type_id);

//d($list);die;

    $br = '<ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="./">控制台</a></li>
        <li class="breadcrumb-item"><a href="./goods.php">商品管理</a></li>
        <li class="breadcrumb-item"><a href="./sku.php">规格属性</a></li>
        <li class="breadcrumb-item active" aria-current="page">' . $cate['name'] . '</li>
    </ol>';

    include View::getAdmView('header');
    require_once View::getAdmView('sku_detail');
    include View::getAdmView('footer');
    View::output();
}



if ($action == 'save') {
    $id = Input::postIntVar('id');
    $type = Input::postStrVar('type');



    if (empty($type)) {
        emDirect("./sku.php?error_a=1");
    }



    if ($id) {
        $Sort_Model->updateSort($sort_data, $sid);
    } else {
        $type_id = $skuModel->addGoodsType(['name' => $type]);
    }

    doAction('save_sku', $sid, $sort_data);

    $CACHE->updateCache(['sort', 'logsort', 'navi']);
    emDirect("./sku.php?active_save=1");
}

if ($action == 'del') {
    $sid = Input::getIntVar('sid');

    LoginAuth::checkToken();

    $Sort_Model->deleteSort($sid);
    $CACHE->updateCache(['sort', 'logsort', 'navi']);
    emDirect("./sort.php?active_del=1");
}

if ($action == 'delAttrValue') {
    $value_id = Input::getIntVar('id');
    LoginAuth::checkToken();
    $type_id = $skuModel->deleteSkuValue($value_id);
    emDirect("./sku.php?action=detail&type_id=" . $type_id);
}

if($action == 'del_sku_attr'){
    $type_id = Input::getIntVar('type_id');
    $id = Input::getIntVar('id');
    $skuModel->deleteSkuAttr($id);
    emDirect("./sku.php?action=detail&type_id=" . $type_id);
}

if($action == 'del_sku_cate'){
    $id = Input::getIntVar('id');
    $skuModel->deleteSkuCate($id);
    emDirect("./sku.php");
}

if($action == 'edit_sku_value'){
    $content = Input::getStrVar('content');
    $type_id = Input::getStrVar('type_id');
    $id = Input::getStrVar('id');
    $skuModel->editSkuValue($id, $content);
    emDirect("./sku.php?action=detail&type_id=" . $type_id);
}

if($action == 'update_sku_attr'){
    $content = Input::getStrVar('content');
    $type_id = Input::getStrVar('type_id');
    $id = Input::getStrVar('id');
    $skuModel->updateSkuAttr($id, $content);
    emDirect("./sku.php?action=detail&type_id=" . $type_id);
}

if($action == 'update_sku'){
    $content = Input::getStrVar('content');
    $id = Input::getStrVar('id');
    $skuModel->updateSku($id, $content);
    emDirect("./sku.php");
}

if($action == 'add_sku_value'){
    $content = Input::getStrVar('content');
    $type_id = Input::getStrVar('type_id');
    $id = Input::getStrVar('id');
    $skuModel->addSkuValue($id, $content);
    emDirect("./sku.php?action=detail&type_id=" . $type_id);
}

if($action == 'add_sku_attr'){
    $content = Input::getStrVar('content');
    $type_id = Input::getStrVar('type_id');
    $data = [
        'type_id' => $type_id,
        'title' => $content
    ];
    $skuModel->addSkuAttr($data);
    emDirect("./sku.php?action=detail&type_id=" . $type_id);
}