<?php
/**
 * sort manager
 * @package EMLOG
 * @link https://www.emlog.net
 */

/**
 * @var string $action
 * @var object $CACHE
 */

require_once 'globals.php';

$Sort_Model = new Sort_Model();

if (empty($action)) {

    $type = Input::getStrVar('type', 'goods');

    $sorts = $Sort_Model->getSorts($type);



    $Template_Model = new Template_Model();
    $customTemplates = $Template_Model->getCustomTemplates('sort');

    if($type == 'goods'){
        $br = '<ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="./">控制台</a></li>
                    <li class="breadcrumb-item"><a href="./goods.php">商品管理</a></li>
                    <li class="breadcrumb-item active" aria-current="page">商品分类</li>
               </ol>';
    }else{
        $br = '<ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="./">控制台</a></li>
                    <li class="breadcrumb-item"><a href="./blog.php">博客管理</a></li>
                    <li class="breadcrumb-item active" aria-current="page">文章分类</li>
               </ol>';
    }


    include View::getAdmView('header');
    require_once View::getAdmView('sort');
    include View::getAdmView('footer');
    View::output();
}

if ($action == 'taxis') {
    $sort = isset($_POST['sort']) ? $_POST['sort'] : '';

    if (empty($sort)) {
        Output::error('没有可排序的分类');
    }

    foreach ($sort as $key => $value) {
        $value = (int)$value;
        $key = (int)$key;
        $Sort_Model->updateSort(array('taxis' => $key), $value);
    }

    $CACHE->updateCache(['sort', 'navi']);
    Output::ok();
}

if ($action == 'save') {
    $sid = Input::postIntVar('sid');
    $sortname = Input::postStrVar('sortname');
    $alias = Input::postStrVar('alias');
    $pid = Input::postIntVar('pid');
    $template = isset($_POST['template']) && $_POST['template'] != 'log_list' ? addslashes(trim($_POST['template'])) : '';
    $description = Input::postStrVar('description');
    $kw = Input::postStrVar('kw');
    $title = Input::postStrVar('title');
    $sortimg = Input::postStrVar('sortimg');
    $type = Input::postStrVar('type');


    if (empty($sortname)) {
        emDirect("./sort.php?error_a=1");
    }

    if ($sid && $sid == $pid) {
        emDirect("./sort.php?error_f=1");
    }

    if (!empty($alias)) {
        if (!preg_match("|^[\w-]+$|", $alias)) {
            emDirect("./sort.php?error_c=1");
        } elseif (preg_match("|^[0-9]+$|", $alias)) {
            emDirect("./sort.php?error_c=1");
        } elseif (in_array($alias, array('post', 'record', 'sort', 'tag', 'author', 'page', 'posts'))) {
            emDirect("./sort.php?error_e=1");
        } else {
            $sort_cache = $CACHE->readCache('sort');
            if ($sid) {
                unset($sort_cache[$sid]);
            }
            foreach ($sort_cache as $key => $value) {
                if ($alias == $value['alias']) {
                    emDirect("./sort.php?error_d=1");
                }
            }
        }
    }

    $sort_data = [
        'sortname'    => $sortname,
        'pid'         => $pid,
        'template'    => $template,
        'description' => $description,
        'kw'          => $kw,
        'title'       => $title,
        'alias'       => $alias,
        'sortimg'     => $sortimg,
        'type' => $type
    ];


    if ($sid) {
        $Sort_Model->updateSort($sort_data, $sid);
    } else {
        $Sort_Model->addSort($sort_data);
    }

    doAction('save_sort', $sid, $sort_data);

    if($type == 'goods'){
        $CACHE->updateCache(['sort', 'logsort', 'navi']);
    }else{
        $CACHE->updateCache(['blog_sort', 'logsort', 'navi']);
    }

    $CACHE->updateCache(['sort', 'logsort', 'navi']);

    if($type == 'goods'){
        emDirect("./sort.php");
    }else{
        emDirect("./sort.php?type=blog");
    }


}

if ($action == 'del') {
    $sid = Input::getIntVar('sid');
    $type = Input::getStrVar('type');

//    LoginAuth::checkToken();

    $Sort_Model->deleteSort($sid);

    if($type == 'goods'){
        $CACHE->updateCache(['sort', 'logsort', 'navi']);
        emDirect("./sort.php");
    }else{
        $CACHE->updateCache(['blog_sort', 'logsort', 'navi']);
        emDirect("./sort.php?type=blog");
    }
}
