<?php defined('EM_ROOT') || exit('access denied!'); ?>

<div style="padding: 20px 0px;">
    <div class="layui-tabs" style="margin-bottom: 12px;" lay-options="{trigger: false}">
        <ul class="layui-tabs-header">
            <li><a href="./setting.php">基础设置</a></li>
            <li><a href="./setting.php?action=user">用户设置</a></li>
            <li><a href="./setting.php?action=seo">SEO设置</a></li>
            <li><a href="./setting.php?action=mail">邮箱配置</a></li>
            <li class="layui-this"><a href="./blogger.php">个人信息</a></li>
        </ul>
    </div>
    <div class="layui-panel">
        <div style="padding: 20px;">
            <form action="blogger.php?action=update" method="post" name="profile_setting_form" id="profile_setting_form" class="layui-form">
                <div class="layui-form-item">
                    <div class="layui-input-block">
                        <label for="upload_image">
                            <img src="<?= $icon ?>" width="120" height="120" id="avatar_image" class="rounded-circle"/>
                            <input type="file" name="image" class="image" id="upload_image" style="display:none"/>
                        </label>
                    </div>
                </div>
                <div class="layui-form-item">
                    <label class="layui-form-label">昵称</label>
                    <div class="layui-input-block">
                        <input class="form-control" value="<?= $nickname ?>" name="name" maxlength="20" required>
                    </div>
                </div>
                <div class="layui-form-item">
                    <label class="layui-form-label">登录账号</label>
                    <div class="layui-input-block">
                        <input class="form-control" value="<?= $username ?>" name="username" id="username">
                    </div>
                </div>
                <input name="token" id="token" value="<?= LoginAuth::genToken() ?>" type="hidden"/>
                <div class="layui-form-item">
                    <div class="layui-input-block">
                        <button type="submit" class="layui-btn" lay-submit lay-filter="demo1">保存设置</button>
                        <a href="#" type="button" class="layui-btn layui-bg-blue" data-toggle="modal" data-target="#editPasswordModal">修改密码</a>
                        <button type="reset" class="layui-btn layui-btn-primary">重置</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>



<div id="modal" style="display: none;">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <div class="img-container">
                    <div class="row">
                        <div class="col-md-11">
                            <img src="" id="sample_image"/>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-sm btn-secondary" data-dismiss="modal">取消</button>
                <button type="button" id="crop" class="btn btn-sm btn-success">保存</button>
                <button type="button" id="use_original_image" class="btn btn-sm btn-primary">使用原图</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="editPasswordModal" tabindex="-1" role="dialog" aria-labelledby="editPasswordModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">修改密码</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="blogger.php?action=change_password" id="passwd_setting_form" method="post">
                    <div class="form-group">
                        <label>新的密码（不少于6位）</label>
                        <input type="password" class="form-control" id="new_passwd" name="new_passwd" minlength="6" required>
                    </div>
                    <div class="form-group">
                        <label>重复新的密码</label>
                        <input type="password" class="form-control" id="new_passwd2" name="new_passwd2" minlength="6" required>
                    </div>
                    <div class="modal-footer">
                        <input name="token" value="<?= LoginAuth::genToken() ?>" type="hidden"/>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                        <button type="submit" class="btn btn-primary">保存</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>



<script>
    $(function () {
        $("#menu-system").attr('class', 'admin-menu-item has-list in');
        $("#menu-system .fa-angle-right").attr('class', 'admin-arrow fa fa-angle-right active');
        $("#menu-system > .submenu").css('display', 'block');
        $('#menu-setting > a').attr('class', 'menu-link active')

        // 提交表单
        $("#profile_setting_form").submit(function (event) {
            event.preventDefault();
            submitForm("#profile_setting_form");
        });

        // 修改用户密码表单提交
        $("#passwd_setting_form").submit(function (event) {
            event.preventDefault();
            submitForm("#passwd_setting_form", '密码修改成功, 请退出重新登录');
            $("#editPasswordModal").modal('hide');
        });



        // 裁剪上传头像
        var $modal = $('#modal');
        var image = document.getElementById('sample_image');
        var cropper;
        $('#upload_image').change(function (event) {
            var files = event.target.files;
            var done = function (url) {
                image.src = url;
                layer.open({
                    type: 1,
                    shade: true,
                    content: $('#modal'), // 捕获的元素
                    closeBtn: 1,
                    index: 'avatar',
                    success: function(layero, index, that){
                        cropper = new Cropper(image, {
                            aspectRatio: 1,
                            viewMode: 1,
                        });
                    },
                    end: function(){
                        cropper.destroy();
                        cropper = null;
                    }
                });


            };
            if (files && files.length > 0) {
                if (!files[0].type.startsWith('image')) {
                    alert('只能上传图片');
                    return;
                }
                reader = new FileReader();
                reader.onload = function (event) {
                    done(reader.result);
                };
                reader.readAsDataURL(files[0]);
            }
        });
        $modal.on('shown.bs.modal', function () {
            cropper = new Cropper(image, {
                aspectRatio: 1,
                viewMode: 1,
            });
        }).on('hidden.bs.modal', function () {
            cropper.destroy();
            cropper = null;
        });

        $('#crop').click(function () {
            canvas = cropper.getCroppedCanvas({
                width: 160,
                height: 160
            });

            canvas.toBlob(function (blob) {
                uploadImage(blob, 'avatar.jpg');
            });
        });

        $('#use_original_image').click(function () {
            var blob = $('#upload_image')[0].files[0];
            uploadImage(blob, blob.name)
        });

        // 上传图片
        function uploadImage(blob, filename) {
            var formData = new FormData();
            formData.append('image', blob, filename);
            $.ajax('./blogger.php?action=update_avatar', {
                method: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function (data) {
                    cropper.destroy();
                    cropper = null;
                    layer.closeAll()
                    if (data.code == 0) {
                        $('#avatar_image').attr('src', data.data);
                    } else {
                        alert(data.msg);
                    }
                },
                error: function (xhr) {
                    cropper.destroy();
                    cropper = null;
                    var data = xhr.responseJSON;
                    if (data && typeof data === "object") {
                        alert(data.msg);
                    } else {
                        alert("上传头像出错了");
                    }
                }
            });
        }
    });
</script>
