<?php defined('EM_ROOT') || exit('access denied!'); ?>
<link rel="stylesheet" type="text/css" href="./views/css/views/goods.css?t=<?= Option::EM_VERSION_TIMESTAMP ?>">
<style>
    .post-type{
        display: <?= $goods['type'] == 'post' ? 'block' : 'none' ?>
    }
</style>
<div class="panel mt-3 bg-white">
    <div class="panel-body">

        <form action="goods_save.php" method="post" enctype="multipart/form-data" id="addgoods" name="addgoods" class=" ">
            <input type="hidden" name="goods_id" value="<?= $goods['id'] ?>" />
            <input name="token" id="token" value="<?= LoginAuth::genToken() ?>" type="hidden"/>

            <!-- 选项卡 -->
            <ul class="nav nav-tabs goods-release-nav" id="myTab" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active" id="basic-tab" data-toggle="tab" href="#basic" role="tab" aria-controls="basic" aria-selected="true">
                        基础信息
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="sku-tab" data-toggle="tab" href="#sku" role="tab" aria-controls="sku" aria-selected="true">
                        规格信息
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="detail-tab" data-toggle="tab" href="#detail" role="tab" aria-controls="detail" aria-selected="true">
                        商品详情
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="attach-tab" data-toggle="tab" href="#attach" role="tab" aria-controls="attach" aria-selected="false">
                        附加选项
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="sales-tab" data-toggle="tab" href="#sales" role="tab" aria-controls="sales" aria-selected="false">
                        营销设置
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="advanced-tab" data-toggle="tab" href="#advanced" role="tab" aria-controls="advanced" aria-selected="false">
                        其他设置
                    </a>
                </li>
            </ul>

            <div class="tab-content" id="myTabContent">
                <!-- 基础设置选项卡 -->
                <div class="tab-pane fade show active in " id="basic" role="tabpanel" aria-labelledby="basic-tab">

                    <div class="form mt-4">
                        <div class="form-group">
                            <label class="form-label">商品类型</label>
                            <?php if($action == 'edit'): ?>
                                <input type="hidden" name="type" value="<?= $goods['type'] ?>" />
                            <?php endif; ?>
                            <div class="check-list-inline">
                                <label><input <?= $action == 'edit' ? 'disabled' : '' ?> type="radio" name="type" value="duli" <?= $goods['type'] == 'duli' || $action == 'release' ? 'checked' : '' ?> /><span class="pl-2">一次性卡密</span></label>
                                <label><input <?= $action == 'edit' ? 'disabled' : '' ?> type="radio" name="type" value="guding" <?= $goods['type'] == 'guding' ? 'checked' : '' ?> /><span class="pl-2">固定通用卡密</span></label>
                                <label><input <?= $action == 'edit' ? 'disabled' : '' ?> type="radio" name="type" value="xuni" <?= $goods['type'] == 'xuni' ? 'checked' : '' ?> /><span class="pl-2">虚拟服务类型</span></label>
                                <label><input <?= $action == 'edit' ? 'disabled' : '' ?> type="radio" name="type" value="post" <?= $goods['type'] == 'post' ? 'checked' : '' ?> /><span class="pl-2">自定义接口URL/POST</span></label>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="form-label">商品分类</label>
                            <select name="sort_id" id="sort" class="form-control">
                                <option value="-1">选择分类...</option>
                                <?php
                                foreach ($sorts as $key => $value):
                                    if ($value['pid'] != 0) {
                                        continue;
                                    }
                                    $flg = $value['sid'] == $goods['sort_id'] ? 'selected' : '';
                                    ?>
                                    <option value="<?= $value['sid'] ?>" <?= $flg ?>><?= $value['sortname'] ?></option>
                                    <?php
                                    $children = $value['children'];
                                    foreach ($children as $key):
                                        $value = $sorts[$key];
                                        $flg = $value['sid'] == $goods['sort_id'] ? 'selected' : '';
                                        ?>
                                        <option value="<?= $value['sid'] ?>" <?= $flg ?>>&nbsp; &nbsp; &nbsp; <?= $value['sortname'] ?></option>
                                    <?php
                                    endforeach;
                                endforeach;
                                ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label class="form-label">商品名称</label>
                            <input name="title" id="title" type="text" class="form-control" placeholder="请输入商品名" value="<?= $goods['title'] ?>">
                        </div>

                        <div class="form-group post-type">
                            <label class="form-label">URL</label>
                            <input name="post_url" id="" type="text" class="form-control" placeholder="请输入访问的URL" value="<?= $goods['post_url'] ?>">
                        </div>



                        <div class="form-group">
                            <label class="form-label">封面图片</label>
                            <input type="text" name="cover" id="cover" value="<?= $goods['cover'] ?>" placeholder="封面图URL" autocomplete="off" class="form-control">
                            <div class="row mt-3">
                                <div class="col-md-4">
                                    <label for="upload_img">
                                        <img src="<?= $goods['cover'] ?: './views/images/cover.svg' ?>" width="200" id="cover_image" class="rounded" alt="封面图片"/>
                                        <input type="file" name="upload_img" class="image" id="upload_img" style="display:none"/>
                                        <button type="button" id="cover_rm" class="btn-sm btn btn-link" <?php if (!$goods['cover']): ?>style="display:none"<?php endif ?>>x</button>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="tab-pane fade" id="sku" role="tabpanel" aria-labelledby="sku-tab">
                    <div class="fairy-form form mt-4">
                        <!--商品规格选项-->
                        <div id="fairy-is-attribute"></div>
                        <!--商品类型选择-->
                        <div id="fairy-product-type"></div>
                        <!--商品属性表-->
                        <div id="fairy-attribute-table"></div>
                        <!--商品规格表-->
                        <div id="fairy-spec-table"></div>
                        <!--商品库存表-->
                        <div id="fairy-sku-table"></div>
                    </div>
                </div>
                <div class="tab-pane fade" id="detail" role="tabpanel" aria-labelledby="detail-tab">
                    <div class="form mt-4">
                        <div class="form-group">
                            <label class="form-label">商品简介</label>
                            <div>
                                <textarea class="form-control" name="des"><?= $goods['des'] ?></textarea>
                            </div>
                        </div>
                        <div class="my-3">
                            <a href="#mediaModal" data-toggle="modal" data-target="#mediaModal"><i class="fa fa-plus"></i> 资源媒体库</a>
                            <?php doAction('adm_goods_release_bar') ?>
                        </div>

                        <div class="form-group">
                            <label class="form-label">商品详情</label>
                            <div>
                                <textarea class="basic-example" name="content"><?= $goods['content'] ?></textarea>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="form-label">卡密页显示内容</label>
                            <div>
                                <textarea class="basic-example" name="pay_content"><?= $goods['pay_content'] ?></textarea>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="tab-pane fade" id="attach" role="tabpanel" aria-labelledby="attach-tab">
                    <div class="form mt-4">
                        <div class="form-group">
                            <label for="keyInput" class="form-label">名称</label>
                            <input type="text" class="form-control" id="keyInput" placeholder="请输入名称">
                        </div>

                        <div class="form-group">
                            <label for="valueInput" class="form-label">提示内容</label>
                            <input type="text" class="form-control" id="valueInput" placeholder="请输入提示内容">
                        </div>

                        <div class="form-group text-right">
                        <span id="addBtn" class="btn primary">
                            <i class="fa fa-plus mr-1"></i>添加
                        </span>
                            <span id="clearBtn" class="btn btn-outline-secondary ml-2">
                            <i class="fa fa-trash mr-1"></i>清空
                        </span>
                        </div>

                        <div class="bg-white p-3 rounded mb-4">
                            <h3 class="h5 form-label mb-3"><i class="fa fa-list-ul mr-2 text-info"></i>已添加的附加选项</h3>
                            <div id="keyValueList">
                                <!-- 键值对将在这里动态添加 -->
                                <div class="text-muted text-center py-4" id="emptyListPlaceholder">
                                    暂无附加选项，请添加
                                </div>
                            </div>
                        </div>

                        <div class="form-group" style="display: none;">
                            <label class="form-label mb-2"><i class="fa fa-code mr-2 text-success"></i>JSON 输出</label>
                            <div class="relative">
                                <textarea name="attach_user" id="jsonOutput" class="form-control" readonly></textarea>
                            </div>
                        </div>
                    </div>


                </div>

                <div class="tab-pane fade" id="sales" role="tabpanel" aria-labelledby="sales-tab">
                    <div class="form mt-4">

                        <div class="">
                            <label class="form-label">配置批量购买，单价优惠</label>

                            <!-- 键值对容器 -->
                            <div id="keyValueContainer" class="mb-4">
                                <!-- 初始键值对 -->
                                <?php if(empty($discount)): ?>
                                <div class="kv-item">
                                    <input step="1" name="discount[number][]" type="number" class="key-input kv-input" placeholder="购买数量" />
                                    <span class="kv-equal">  </span>
                                    <input step="0.01" name="discount[amount][]" type="number" class="value-input kv-input" placeholder="每一件优惠金额" /><button type="button" class="kv-btn delete-btn btn danger btn-sm" title="删除"><i class="fa fa-trash-o"></i></button><button type="button" class="kv-btn add-btn btn primary btn-sm btn-add" title="添加"><i class="fa fa-plus"></i></button>
                                </div>
                                <?php else: ?>
                                    <?php foreach($discount as $val): ?>
                                            <div class="kv-item">
                                                <input value="<?= $val['quantity'] ?>" step="1" name="discount[number][]" type="number" class="key-input kv-input" placeholder="购买数量" />
                                                <span class="kv-equal">  </span>
                                                <input value="<?= $val['amount'] / 100 ?>" step="0.01" name="discount[amount][]" type="number" class="value-input kv-input" placeholder="每一件优惠金额" /><button type="button" class="kv-btn delete-btn btn danger btn-sm" title="删除"><i class="fa fa-trash-o"></i></button><button type="button" class="kv-btn add-btn btn primary btn-sm btn-add" title="添加"><i class="fa fa-plus"></i></button>
                                            </div>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>

                        </div>

                        <div class="form-group">
                            <label class="form-label">销量</label>
                            <input name="sales" id="" type="number" class="form-control" placeholder="" value="<?= $goods['sales'] ?>">
                        </div>


                    </div>
                </div>

                <!-- 其他设置选项卡 -->
                <div class="tab-pane fade" id="advanced" role="tabpanel" aria-labelledby="advanced-tab">
                    <div class="mt-4 form">

                        <div class="form-group">

                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="is_on_shelf" name="is_on_shelf" value="1" <?= $goods['is_on_shelf'] == 1 ? 'checked' : '' ?>>
                                <label class="custom-control-label is-on-shelf" for="is_on_shelf">上架</label>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="index_top" name="index_top" value="1" <?= $goods['index_top'] == 1 ? 'checked' : '' ?>>
                                <label class="custom-control-label is-on-shelf" for="index_top">首页置顶</label>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="sort_top" name="sort_top" value="1" <?= $goods['sort_top'] == 1 ? 'checked' : '' ?>>
                                <label class="custom-control-label is-on-shelf" for="sort_top">分类页置顶</label>
                            </div>
                        </div>



                        <div class="form-group">
                            <label class="form-label">排序</label>
                            <input name="sort_num" id="" type="number" class="form-control" placeholder="" value="<?= $goods['sort_num'] ?>">
                        </div>

                    </div>
                </div>
            </div>

            <input type="submit" name="pubPost" id="pubPost" value="保存商品" onclick="return checkform();" class="btn primary mt-5">


        </form>
    </div>
</div>

<div class="modal" id="mediaModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">资源媒体库</h5>
                <button type="button" class="close close-media-btn" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="d-flex justify-content-between">
                    <div><a href="#" id="mediaAdd" class="btn btn-sm btn-success shadow-sm mb-3">上传图片/文件</a></div>
                    <div>
                        <?php if (User::haveEditPermission() && $mediaSorts): ?>
                            <select class="form-control" id="media-sort-select">
                                <option value="">选择资源分类…</option>
                                <?php foreach ($mediaSorts as $v): ?>
                                    <option value="<?= $v['id'] ?>"><?= $v['sortname'] ?></option>
                                <?php endforeach ?>
                            </select>
                        <?php endif ?>
                    </div>
                </div>
                <form action="media.php?action=operate_media" method="post" name="form_media" id="form_media">
                    <div class="grid-cols-lg-4 grid-gap-12" id="image-list"></div>
                    <div class="text-center">
                        <button type="button" class="btn btn-success btn-sm mt-2" id="load-more">加载更多…</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- 封面图裁剪 -->
<div class="modal" id="modal">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">上传封面</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="img-container">
                    <div class="row">
                        <div class="col-md-11">
                            <img src="" id="sample_image"/>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer justify-content-between">
                <div>按住 Shift 等比例调整裁剪区域</div>
                <div>
                    <button type="button" class="btn btn-sm btn-secondary" id="hide-modal" data-dismiss="modal">取消</button>
                    <button type="button" id="crop" class="btn btn-sm btn-success">保存</button>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="dropzone-previews" style="display: none;"></div>
<script src="./views/js/dropzone.min.js?t=<?= Option::EM_VERSION_TIMESTAMP ?>"></script>
<script src="./views/js/media-lib.js?t=<?= Option::EM_VERSION_TIMESTAMP ?>"></script>


<script src="./views/components/lay-module/sortable.js?t=<?= Option::EM_VERSION_TIMESTAMP ?>"></script>
<script src="./views/components/lay-module/skuTable.js?t=<?= Option::EM_VERSION_TIMESTAMP ?>"></script>

<script src="./tinymce/js/tinymce/tinymce.min.js?t=<?= Option::EM_VERSION_TIMESTAMP ?>"></script>

<script src="./views/js/views/goods.js?t=<?= Option::EM_VERSION_TIMESTAMP ?>"></script>



<script>

    const memberLevels = <?= json_encode($members) ?>;

    var form = $('#addgoods');

    var thed = [
        {title: '游客访问(元)', icon: 'icon-edit'},
        {title: '登录用户(元)', icon: 'icon-edit'},
        {title: '市场价(元)', icon: 'icon-edit'},
        {title: '成本价(元)', icon: 'icon-edit'},
    ];
    // 循环会员等级数组，生成对应的对象并添加到thed中
    memberLevels.forEach((level, index) => {
        thed.splice(2 + index, 0, {
            title: `${level.name}(元)`,
            icon: 'icon-edit'
        });
    });

    var tbody = [
        {type: 'input', field: 'guest_price', value: '', verify: 'required|number', reqtext: '不能为空'},
        {type: 'input', field: 'user_price', value: '', verify: 'required|number', reqtext: '不能为空'},
        {type: 'input', field: 'market_price', value: '', verify: 'required|number', reqtext: '市场价不能为空'},
        {type: 'input', field: 'cost_price', value: '0', verify: 'required|number', reqtext: '成本价不能为空'},
    ];

    // 循环会员等级数组，生成对应的对象并添加到thed中

    memberLevels.forEach((level, index) => {

        tbody.splice(2 + index, 0, {
            type: 'input',
            field: `member_${level.id}`,
            value: '',
            verify: 'required|number',
            reqtext: '不能为空'
        });
    });

    console.log(tbody)
    <?php if($action == 'edit'): ?>
        var tbody2 = [ // 单规格
            {type: 'input', field: 'skus[guest_price]', value: "<?= $goods['skus'][0]['guest_price'] /100 ?>", verify: 'required|number', reqtext: '不能为空'},
            {type: 'input', field: 'skus[user_price]', value: "<?= $goods['skus'][0]['user_price'] /100 ?>", verify: 'required|number', reqtext: '不能为空'},
            {type: 'input', field: 'skus[market_price]', value: "<?= $goods['skus'][0]['market_price'] /100 ?>", verify: 'required|number', reqtext: '市场价不能为空'},
            {type: 'input', field: 'skus[cost_price]', value: "<?= $goods['skus'][0]['cost_price'] /100 ?>", verify: 'required|number', reqtext: '成本价不能为空'},
        ];

        var member_price = JSON.parse('<?= $goods['skus_json'] ?>')[0].member_prices;

        memberLevels.forEach((level, index) => {

            // 查找当前会员等级对应的价格数据
            const priceData = member_price.find(price => price.member_level == level.id);


            tbody2.splice(2 + index, 0, {
                type: 'input',
                field: `skus[member][${level.id}]`,
                value: priceData ? priceData.price.toString() / 100: '', // 有价格则显示，否则为空
                verify: 'required|number',
                reqtext: '不能为空'
            });
        });
    <?php endif; ?>

    <?php if($action == 'release'): ?>
        var tbody2 = [ // 单规格
            {type: 'input', field: 'skus[guest_price]', value: "", verify: 'required|number', reqtext: '不能为空'},
            {type: 'input', field: 'skus[user_price]', value: "", verify: 'required|number', reqtext: '不能为空'},
            {type: 'input', field: 'skus[market_price]', value: "", verify: 'required|number', reqtext: '市场价不能为空'},
            {type: 'input', field: 'skus[cost_price]', value: "", verify: 'required|number', reqtext: '成本价不能为空'},
        ];
        memberLevels.forEach((level, index) => {
            tbody2.splice(2 + index, 0, {
                type: 'input',
                field: `skus[member][${level.id}]`,
                value: '',
                verify: 'required|number',
                reqtext: '不能为空'
            });
        });
    <?php endif; ?>

    var options = {
        isAttributeElemId: 'fairy-is-attribute',
        productTypeElemId: 'fairy-product-type',
        attributeTableElemId: 'fairy-attribute-table',
        specTableElemId: 'fairy-spec-table',
        skuTableElemId: 'fairy-sku-table',
        //商品规格模式 0单规格 1多规格
        mode: "<?= $goods['is_sku'] == 'y' ? 1 : 0 ?>",
        //是否开启sku表行合并
        rowspan: true,
        //图片上传接口
        uploadUrl: './json/upload.json',
        //获取商品类型接口
        productTypeUrl: '?action=goods_type_data',
        //获取商品类型下的规格和属性接口
        attrSpecUrl: '?action=attr_spec_data',
        //创建规格接口
        specCreateUrl: '?action=create_spec',
        //删除规格接口
        specDeleteUrl: './json/specD    elete.json',
        //创建规格值接口
        specValueCreateUrl: '?action=create_spec_value',
        //删除规格值接口
        specValueDeleteUrl: './json/specValueDelete.json',
        //单规格SKU表配置
        singleSkuTableConfig: {
            thead: thed,
            tbody: tbody2
        },
        //多规格SKU表配置
        multipleSkuTableConfig: {
            thead: thed,
            tbody: tbody
        },
        // ========================================== 回显时相关配置参数 ========================================== //
        //商品id
        goods_id: "<?php echo $goods['id'] ?>",
        //商品类型id
        productTypeId: "<?= isset($goods['attr_id']) ? $goods['attr_id'] : '' ?>",
        //sku数据接口
        skuDataUrl: '?action=sku_data',
    }

    var skuTableObj = new SkuTable(options);

    form.on('submit', function (data) {

        console.log(data)

        //获取表单数据
        console.log(data.field);

        // return false;

        if (skuTableObj.getMode() == 0) {
            //单规格
            // layer.alert(JSON.stringify(data.field), {title: '提交的数据'});
        } else {
            //多规格
            var state = Object.keys(data.field).some(function (item, index, array) {
                return item.startsWith('skus');
            });
            // state ? layer.alert(JSON.stringify(data.field), {title: '提交的数据'}) : layer.msg('sku表数据不能为空', {icon: 5, anim: 6});
        }

        return true;
    });

</script>
<script>
    $("#alias").on("keyup", function () {
        checkalias();
    });
    $("#menu-goods").attr('class', 'admin-menu-item has-list in');
    $("#menu-goods .fa-angle-right").attr('class', 'admin-arrow fa fa-angle-right active');
    $("#menu-goods > .submenu").css('display', 'block');
    $('#menu-goods-list > a').attr('class', 'menu-link active')



    // 封面图
    $(function() {
        var $modal = $('#modal');
        var image = document.getElementById('sample_image');
        var cropper;
        $('#upload_img').change(function(event) {
            var files = event.target.files;
            var done = function(url) {
                image.src = url;
                zui.Modal.open({
                    id: 'modal'
                });
            };
            if (files && files.length > 0) {
                if (!files[0].type.startsWith('image')) {
                    alert('只能上传图片');
                    return;
                }
                reader = new FileReader();
                reader.onload = function(event) {
                    done(reader.result);
                };
                reader.readAsDataURL(files[0]);
            }
        });
        $modal.on('shown.bs.modal', function() {
            cropper = new Cropper(image, {
                aspectRatio: NaN,
                viewMode: 1
            });
        }).on('hidden.bs.modal', function() {
            cropper.destroy();
            cropper = null;
        });

        // 上传图片
        function uploadImage(blob, filename) {
            
            var formData = new FormData();
            formData.append('image', blob, filename);
            $.ajax('./goods.php?action=upload_cover', {
                method: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(data) {
                    zui.Modal.hide({
                        id: 'modal'
                    })
                    $('#hide-modal').click()
                    if (data.code == 0) {
                        $('#cover_image').attr('src', data.data);
                        $('#cover').val(data.data);
                        $('#cover_rm').show();
                    } else {
                        alert(data.msg);
                    }
                },
                error: function(xhr) {
                    var data = xhr.responseJSON;
                    if (data && typeof data === "object") {
                        alert(data.msg);
                    } else {
                        alert("上传封面出错了");
                    }
                }
            });
        }

        $('#crop').click(function() {
            canvas = cropper.getCroppedCanvas({
                width: 650,
                height: 366
            });
            canvas.toBlob(function(blob) {
                uploadImage(blob, 'cover.jpg')
            });
        });

        $('#use_original_image').click(function() {
            var blob = $('#upload_img')[0].files[0];
            uploadImage(blob, blob.name)
        });

        $('#cover_rm').click(function() {
            $('#cover_image').attr('src', "./views/images/cover.svg");
            $('#cover').val("");
            $('#cover_rm').hide();
        });
    });

    $('#cover').blur(function() {
        c = $('#cover').val();
        if (!c) {
            $('#cover_image').attr('src', "./views/images/cover.svg");
            $('#cover_rm').hide();
            return
        }
        $('#cover_image').attr('src', c);
        $('#cover_rm').show();
    });



</script>

<!--附加选项-->
<script>
    let keyValuePairs = <?= $goods['attach_user'] ? $goods['attach_user'] : '{}' ?>;

    console.log(keyValuePairs)

    // 添加键值对
    $('#addBtn').click(function() {
        const key = $('#keyInput').val().trim();
        const value = $('#valueInput').val().trim();

        if (!key) {
            layer.msg('请输入标题');
            return;
        }

        // 更新或添加键值对
        keyValuePairs[key] = value;
        updateKeyValueList();
        updateJsonOutput();

        // 清空输入框
        $('#keyInput').val('');
        $('#valueInput').val('');
        $('#keyInput').focus();

        layer.msg('附加选项已添加');
    });

    // 清空所有键值对
    $('#clearBtn').click(function() {
        if (Object.keys(keyValuePairs).length === 0) {
            layer.msg('列表已为空');
            return;
        }

        if (confirm('确定要清空所有附加选项吗？')) {
            keyValuePairs = {};
            updateKeyValueList();
            updateJsonOutput();
            layer.msg('已清空所有附件选项')
        }
    });



    // 回车键添加键值对
    $('#valueInput').keypress(function(e) {
        if (e.which === 13) {
            e.preventDefault();
            $('#addBtn').click();
        }
    });

    // 更新键值对列表
    function updateKeyValueList() {
        const listContainer = $('#keyValueList');
        listContainer.empty();

        if (Object.keys(keyValuePairs).length === 0) {
            listContainer.append('<div class="text-muted text-center py-4" id="emptyListPlaceholder">暂无附加选项，请添加</div>');
            return;
        }

        Object.entries(keyValuePairs).forEach(([key, value]) => {
            const item = $(`
                        <div class="bg-white border border-light rounded p-3 mb-2 d-flex justify-between align-items-center">
                            <div class="flex-grow-1">
                                <div class="form-label">${escapeHtml(key)}</div>
                                <div class="text-sm text-muted mt-1">${escapeHtml(value)}</div>
                            </div>
                            <div class="ml-2">
                                <span class="delete-btn" data-key="${escapeHtml(key)}">
                                    <i class="fa fa-times-circle"></i>
                                </span>
                            </div>
                        </div>
                    `);

            // 添加删除事件
            item.find('.delete-btn').click(function() {
                const keyToDelete = $(this).data('key');
                delete keyValuePairs[keyToDelete];
                updateKeyValueList();
                updateJsonOutput();
                layer.msg(`已删除附加选项: ${keyToDelete}`)
            });

            listContainer.append(item);
        });
    }

    // 更新JSON输出
    function updateJsonOutput() {
        const jsonOutput = $('#jsonOutput');
        const jsonString = JSON.stringify(keyValuePairs, null, 2);
        jsonOutput.val(jsonString);

        // 自动调整文本区域高度
        jsonOutput.height(0);
        jsonOutput.height(jsonOutput.prop('scrollHeight'));
    }

    // 显示提示消息
    function showToast(message, type) {
        // 移除已有的toast
        $('.custom-toast').remove();

        let bgColor, icon;
        switch(type) {
            case 'success':
                bgColor = 'bg-success';
                icon = 'fa-check-circle';
                break;
            case 'warning':
                bgColor = 'bg-warning';
                icon = 'fa-exclamation-triangle';
                break;
            case 'error':
                bgColor = 'bg-error';
                icon = 'fa-times-circle';
                break;
            default:
                bgColor = 'bg-info';
                icon = 'fa-info-circle';
        }

        const toast = $(`
                    <div class="custom-toast ${bgColor}">
                        <i class="fa ${icon} mr-2"></i>
                        <span>${message}</span>
                    </div>
                `);

        $('body').append(toast);

        // 淡入
        setTimeout(() => {
            toast.addClass('show');
        }, 10);

        // 3秒后淡出
        setTimeout(() => {
            toast.removeClass('show');
            setTimeout(() => {
                toast.remove();
            }, 300);
        }, 3000);
    }

    // 页面加载时更新列表和JSON输出
    updateKeyValueList();
    updateJsonOutput();

    // 转义HTML特殊字符
    function escapeHtml(text) {
        return text
            .replace(/&/g, "&amp;")
            .replace(/</g, "&lt;")
            .replace(/>/g, "&gt;")
            .replace(/"/g, "&quot;")
            .replace(/'/g, "&#039;");
    }
</script>