<?php defined('EM_ROOT') || exit('access denied!'); ?>


<style>


    /* 卡片基础样式 */
    .panel.bg-white.shadow-lg {
        border-radius: 12px;
        border: none;
        overflow: hidden;
        transition: all 0.3s ease;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
    }

    .panel.bg-white.shadow-lg:hover {
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.08);
    }

    /* 卡片内容区域 */
    .panel-body {
        padding: 1rem;
        padding-bottom: 0.9rem;
    }

    /* 标签样式统一 */
    .label {
        display: inline-block;
        padding: 0.25rem 0.75rem;
        font-size: 0.875rem;
        font-weight: 500;
        text-decoration: none;
        transition: all 0.2s ease;
    }

    .label.warning {
        background-color: #fff8e1;
        color: #ff9800;
    }

    .label.success {
        background-color: #e8f5e9;
        color: #4caf50;
    }

    .label.primary {
        background-color: #e3f2fd;
        color: #2196f3;
    }

    .label.success-pale {
        background-color: #e0f7fa;
        color: #00acc1;
    }

    /* 主数据样式 */
    p.info.mt-5 {
        margin: 1rem 0;
        font-weight: 700;
        color: #2d3748;
        line-height: 1.2;
    }



    /* 底部信息区域 */
    .flex.justify-between.mt-4 {
        color: #718096;
        font-size: 0.9rem;
    }

    /* 按钮样式 */
    .btn.size-sm {
        background-color: #f7fafc;
        color: #2196f3;
        border: 1px solid #e6edf7;
        padding: 0.25rem 0.75rem;
        font-size: 0.875rem;
        transition: all 0.2s ease;
    }

    .btn.size-sm:hover {
        background-color: #ebf4ff;
        border-color: #bed7ff;
    }



</style>

<div class="row" style="margin-top: 10px; margin-bottom: 14px;">
    <div class="col-lg-12">
        <?php doAction('adm_main_top') ?>
    </div>
</div>


<div class="">
    <div class="grid-cols-xl-5 grid-cols-lg-3 grid-cols-md-2 grid-cols-sm-1 mb-3 grid-gap-10" style="width: 100%;">

        <div class="panel bg-white shadow-lg">
            <div class="panel-body">
                <span>系统版本</span>
                <?php if (!Register::isRegLocal()) : ?>
                    <a style="float: right;" href="<?= SERVICE_HOST ?>/index/register/index" target="_blank"><span class="label ">未授权</span></a>
                <?php else: ?>
                    <?php if (Register::getRegType() === 2): ?>
                        <a style="float: right;" href="<?= SERVICE_HOST ?>/index/register/index" target="_blank" class="label warning">SVIP</a>
                    <?php elseif (Register::getRegType() === 1): ?>
                        <a style="float: right;" href="<?= SERVICE_HOST ?>/index/register/index" target="_blank" class="label success">VIP</a>
                    <?php else: ?>
                        <a style="float: right;" href="<?= SERVICE_HOST ?>/index/register/index" target="_blank" class="label primary">已注册</a>
                    <?php endif ?>
                <?php endif; ?>
                <p class="info mt-5" style="font-size: 30px;">v<?= ucfirst(Option::EM_VERSION) ?></p>
                <div class="pb-3 mt-2" style="border-bottom: 1px solid #eee;"><?= SERVICE_NAME ?></span></div>
                <div class="flex justify-between mt-4">
                    <span>检查新版本</span>
                    <span id="check-update-btn" onclick="checkUpdate()" data-toggle="modal" data-target="#update-modal" class="cursor-pointer btn size-sm">
                        检查更新
                    </span>
                </div>
            </div>
        </div>


        <div class="panel bg-white shadow-lg">
            <div class="panel-body">
                <div class="flex justify-between">
                    <span>订单数量</span>
                    <span class="label success-pale">今日</span>
                </div>

                <p class="info mt-5" style="font-size: 30px;"><?= $order_panel['today_orders'] ?></p>
                <div class="pb-3 mt-2" style="border-bottom: 1px solid #eee;">昨日 <?= $order_panel['yesterday_orders'] ?> 单</span></div>
                <div class="flex justify-between mt-4">
                    <span>本月订单量 </span>
                    <span><?= $order_panel['month_orders'] ?> 单</span>
                </div>
            </div>
        </div>
        <div class="panel bg-white shadow-lg">
            <div class="panel-body">
                <div class="flex justify-between">
                    <span>销售额</span>
                    <span class="label success-pale">今日</span>
                </div>

                <p class="info mt-5" style="font-size: 30px;"><?= $today_sales_amount ?></p>
                <div class="pb-3 mt-2" style="border-bottom: 1px solid #eee;">昨日 <?= $yesterday_sales_amount ?> 元</span></div>
                <div class="flex justify-between mt-4">
                    <span>本月销售额 </span>
                    <span><?= $current_month_sales_amount ?> 元</span>
                </div>
            </div>
        </div>

        <div class="panel bg-white shadow-lg">
            <div class="panel-body">
                <div class="flex justify-between">
                    <span>客单价</span>
                    <span class="label success-pale">今日</span>
                </div>

                <p class="info mt-5" style="font-size: 30px;"><?= empty($today_sales_amount) || empty($order_panel['today_orders']) ? number_format(0, 2) : number_format($today_sales_amount / $order_panel['today_orders'], 2) ?></p>
                <div class="pb-3 mt-2" style="border-bottom: 1px solid #eee;">昨日 <?= empty($yesterday_sales_amount) || empty($order_panel['yesterday_orders']) ? number_format(0, 2) : number_format($yesterday_sales_amount / $order_panel['yesterday_orders'], 2) ?> 元</span></div>
                <div class="flex justify-between mt-4">
                    <span>本月客单价 </span>
                    <span><?= empty($current_month_sales_amount) || empty($order_panel['month_orders']) ? number_format(0, 2) : number_format($current_month_sales_amount / $order_panel['month_orders'], 2) ?> 元</span>
                </div>
            </div>
        </div>

        <div class="panel bg-white shadow-lg">
            <div class="panel-body">
                <div class="flex justify-between">
                    <span>新增用户</span>
                    <span class="label success-pale">今日</span>
                </div>

                <p class="info mt-5" style="font-size: 30px;"><?= $user_panel['today_registrations'] ?></p>
                <div class="pb-3 mt-2" style="border-bottom: 1px solid #eee;">昨日 <?= $user_panel['yesterday_registrations'] ?> 人</span></div>
                <div class="flex justify-between mt-4">
                    <span>本月新增用户 </span>
                    <span><?= $user_panel['month_registrations'] ?> 人</span>
                </div>
            </div>
        </div>










    </div>


</div>



<div class="mt-4 shadow-lg">
    <?php if (User::isAdmin()): ?>
        <?php if (!Register::isRegLocal()) : ?>

            <div class="panel secondary-pale sq-panel">
                <div class="panel-heading">
                    您安装的<?= SERVICE_NAME ?>尚未授权，完成授权可使用全部功能，包括如下：
                </div>
                <div class="panel-body bg-white text-black">
                    <table class="table sq-table">
                        <tr>
                            <td>1. 解锁在线升级功能，一键升级到最新版本，获得来自官方的安全和功能更新</td>
                        </tr>
                        <tr>
                            <td>2. 解锁应用商店，获得更多模板和插件，并支持应用在线一键更新</td>
                        </tr>
                        <tr>
                            <td>3. 去除所有未注册提示及功能限制，加入专属Q群，获得官方技术指导问题解答</td>
                        </tr>
                        <tr>
                            <td style="padding-top: 15px;">
                                <a href="auth.php" class="btn btn-sm warning shadow-lg mr-2">去授权</a>
                                <a href="<?= SERVICE_HOST ?>/index/register/index" target="_blank" class="btn btn-sm primary shadow-lg">获取授权码-></a>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        <?php endif ?>

        <style>
            @media (max-width: 576px) {
                #update-modal .modal-dialog {
                    max-width: 95%;
                    margin: 2vh auto;
                }
            }


        </style>
        <div class="modal fade" id="update-modal" tabindex="-1" role="dialog" aria-labelledby="update-modal-label" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable" style="max-width: 500px; max-height: 90vh; margin: 5vh auto;">
                <!-- 添加 modal-dialog-scrollable 和 max-height -->
                <div class="modal-content" style="height: auto; max-height: 90vh; display: flex; flex-direction: column;">
                    <div class="modal-header">
                        <h5 class="modal-title" id="update-modal-label">检查更新</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body" style="overflow-y: auto; flex: 1; min-height: 0;">

                        <!-- 添加 flex 布局和滚动 -->
                        <div id="update-modal-loading">
                            <i class="animate-spin icon icon-spinner-indicator"></i> 正在检查是否有更新内容
                        </div>
                        <div id="update-modal-msg" class="text-center"></div>
                        <div id="update-modal-changes" style="max-height: calc(90vh - 200px); overflow-y: auto;"></div>
                        <!-- 为变化内容单独添加滚动 -->
                        <div id="update-modal-btn" class="mt-2 text-right"></div>
                    </div>
                </div>
            </div>
        </div>


    <?php endif ?>
</div>





<?php if (User::isAdmin()): ?>
    <div class="row">
        <?php doAction('adm_main_content') ?>
    </div>
<?php endif; ?>


<script>


    $("#menu-dashboard").addClass('active');

    $.get("./upgrade.php?action=check_update", function (result) {
        if (result.code === 200) {
            $('#check-update-btn').addClass('danger');
            $('#check-update-btn').html('点击更新 v' + result.data.list[0].version);
        }
    });
</script>