<?php defined('EM_ROOT') || exit('access denied!'); ?>

<style>

</style>


<div class="mt-3 panel bg-white">
    <div class="panel-body">
        <div class="table-container">
            <!-- 表格头部 -->
            <div class="table-header justify-between flex">
                <div class="">
                    <button class="btn btn-action btn-add primary" data-toggle="modal" data-target="#addModal">
                        <i class="fa fa-plus"></i> 新增
                    </button>
                    <button class="btn btn-action btn-batch-delete danger ml-1" id="batchDeleteBtn" disabled>
                        <i class="fa fa-trash"></i> 删除选中
                    </button>
                </div>
                <div class="search-box w-64">
                    <div class="input-control has-suffix">
                        <input type="text" class="form-control" placeholder="搜索等级名称..." name="keyword" value="" />
                        <span class="input-control-suffix"><i class="icon icon-search"></i></span>
                    </div>
                </div>
            </div>

            <!-- 表格内容 -->
            <div class="table-responsive table-box">
                <table class="table custom-table mt-4">
                    <thead>
                    <tr>
                        <th style="width: 50px;"><input type="checkbox" id="selectAll"></th>
                        <th style="width: 80px;">ID</th>
                        <th>等级名称</th>
                        <th style="width: 180px;">操作</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach($members as $val): ?>
                        <tr>
                            <td><input type="checkbox" class="select-item"></td>
                            <td><?= $val['id'] ?></td>
                            <td><?= $val['name'] ?></td>
                            <td>
                                <button class="btn btn-action btn-edit size-sm primary" data-toggle="modal" data-target="#editModal">
                                    <i class="fa fa-pencil"></i> 编辑
                                </button>
                                <button class="btn btn-action btn-delete size-sm danger ml-1" data-toggle="modal" data-target="#deleteModal">
                                    <i class="fa fa-trash"></i> 删除
                                </button>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <!-- 分页 -->
            <?php if($dataCount > Option::get('admin_article_perpage_num')): ?>
                <div class="pagination-container">
                    <div class="pager"><?= $pageurl ?></div>
                </div>
            <?php endif ?>
        </div>
    </div>

</div>

<!-- 新增模态框 -->
<div class="modal fade modal-center" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addModalLabel">新增等级</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form>
                    <div class="form-group">
                        <label for="addLevelName">等级名称</label>
                        <input type="text" class="form-control" id="addLevelName" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <input name="token" id="add-token" value="<?= LoginAuth::genToken() ?>" type="hidden"/>
                <button type="button" class="btn btn-secondary close-btn" data-dismiss="modal">取消</button>
                <button type="button" class="btn btn-primary">保存</button>
            </div>
        </div>
    </div>
</div>

<!-- 编辑模态框 -->
<div class="modal fade modal-center" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editModalLabel">编辑等级</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form>
                    <div class="form-group">
                        <label for="editId">ID</label>
                        <input type="text" class="form-control" id="editId" readonly>
                    </div>
                    <div class="form-group">
                        <label for="editLevelName">等级名称</label>
                        <input type="text" class="form-control" id="editLevelName" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <input name="token" id="edit-token" value="<?= LoginAuth::genToken() ?>" type="hidden"/>
                <button type="button" class="btn btn-secondary close-btn" data-dismiss="modal">取消</button>
                <button type="button" class="btn btn-primary">保存更改</button>
            </div>
        </div>
    </div>
</div>

<!-- 删除确认模态框 -->
<div class="modal fade modal-center" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">确认删除</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>确定要删除此等级吗？此操作不可撤销。</p>
                <input type="hidden" id="deleteId">
            </div>
            <div class="modal-footer">
                <input name="token" id="delete_token" value="<?= LoginAuth::genToken() ?>" type="hidden"/>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                <button type="button" class="btn btn-danger">删除</button>
            </div>
        </div>
    </div>
</div>
<!-- 批量删除确认模态框 -->
<div class="modal fade modal-center" id="batchDeleteModal" tabindex="-1" role="dialog" aria-labelledby="batchDeleteModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="batchDeleteModalLabel">确认批量删除</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>确定要删除选中的等级吗？此操作不可撤销。</p>
                <input type="hidden" id="batchDeleteIds">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                <button type="button" class="btn btn-danger" id="confirmBatchDelete">删除</button>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {


        $('#addModal .btn-primary').on('click', function() {
            // 获取等级名称
            var name = $('#addLevelName').val().trim();
            var add_token = $('#add-token').val().trim();

            $.post('?action=add', {name: name, token: add_token}, function(e){
                // 关闭模态框
                $('#close-btn').click();
                location.reload();
            },"json");
        });


        $('#deleteModal .btn-danger').on('click', function() {
            // 获取等级名称
            var id = $('#deleteId').val().trim();
            var token = $('#delete_token').val().trim();

            $.post('?action=del', {id: id, token: token}, function(e){
                // 关闭模态框
                $('#close-btn').click();
                location.reload();
            },"json");
        });

        $('#editModal .btn-primary').on('click', function() {
            // 获取等级名称
            var id = $('#editId').val();
            var name = $('#editLevelName').val().trim();
            var token = $('#edit-token').val().trim();

            $.post('?action=edit', {name: name, token: token, id: id}, function(e){
                // 关闭模态框
                $('#close-btn').click();
                location.reload();
            },"json");
        });



        // 编辑按钮点击事件
        $('.btn-edit').on('click', function() {
            var row = $(this).closest('tr');
            var id = row.find('td:eq(1)').text(); // 注意索引变化，因为增加了复选框列
            var levelName = row.find('td:eq(2)').text();

            $('#editId').val(id);
            $('#editLevelName').val(levelName);
        });

        // 删除按钮点击事件
        $('.btn-delete').on('click', function() {
            var row = $(this).closest('tr');
            var id = row.find('td:eq(1)').text(); // 注意索引变化，因为增加了复选框列

            $('#deleteId').val(id);
        });

        // 全选/取消全选
        $('#selectAll').on('change', function() {
            var isChecked = $(this).prop('checked');
            $('.select-item').prop('checked', isChecked);
            updateBatchDeleteButton();
        });

        // 单个选择框变化时
        $('.select-item').on('change', function() {
            // 如果所有单选框都被选中，则全选框也被选中
            var allChecked = $('.select-item:checked').length === $('.select-item').length;
            $('#selectAll').prop('checked', allChecked);

            // 如果有任何单选框被选中，则部分选中
            var anyChecked = $('.select-item:checked').length > 0;
            if (anyChecked && !allChecked) {
                $('#selectAll').prop('indeterminate', true);
            } else {
                $('#selectAll').prop('indeterminate', false);
            }

            updateBatchDeleteButton();
        });

        // 更新批量删除按钮状态
        function updateBatchDeleteButton() {
            var selectedCount = $('.select-item:checked').length;
            $('#batchDeleteBtn').prop('disabled', selectedCount === 0);
        }

        // 批量删除按钮点击事件
        $('#batchDeleteBtn').on('click', function() {
            var selectedIds = [];
            $('.select-item:checked').each(function() {
                var row = $(this).closest('tr');
                var id = row.find('td:eq(1)').text(); // 注意索引变化，因为增加了复选框列
                selectedIds.push(id);
            });

            $('#batchDeleteIds').val(selectedIds.join(','));
            $('#batchDeleteModal').modal('show');
        });

        // 确认批量删除
        $('#confirmBatchDelete').on('click', function() {
            // 这里可以添加实际的批量删除逻辑
            var selectedIds = $('#batchDeleteIds').val().split(',');
            console.log('批量删除ID:', selectedIds);

            // 演示用：删除选中的行
            $('.select-item:checked').each(function() {
                $(this).closest('tr').remove();
            });

            // 重置选择状态
            $('#selectAll').prop('checked', false);
            $('#selectAll').prop('indeterminate', false);
            updateBatchDeleteButton();

            $('#batchDeleteModal').modal('hide');
        });

        // 搜索功能
        $('.search-box input').on('input', function() {
            var searchTerm = $(this).val().toLowerCase();

            $('.custom-table tbody tr').each(function() {
                var levelName = $(this).find('td:eq(2)').text().toLowerCase(); // 注意索引变化，因为增加了复选框列

                if (levelName.includes(searchTerm)) {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            });
        });

        // 分页功能
        $('.pagination li').on('click', function() {
            if (!$(this).hasClass('disabled') && !$(this).hasClass('active')) {
                $('.pagination li').removeClass('active');
                $(this).addClass('active');

                // 这里可以添加加载不同页面数据的逻辑
                // 为了演示，我们只是模拟分页效果
                var pageNumber = $(this).find('a').text();
                updatePaginationInfo(pageNumber);
            }
        });

        // 更新分页信息
        function updatePaginationInfo(pageNumber) {
            var itemsPerPage = 5;
            var startItem = (pageNumber - 1) * itemsPerPage + 1;
            var endItem = Math.min(pageNumber * itemsPerPage, 20);

            $('.pagination-info').text(`显示 ${startItem}-${endItem} 条，共 20 条`);
        }
    });
</script>
<script>
    $(function () {


        $("#menu-user").attr('class', 'admin-menu-item has-list in');
        $("#menu-user .fa-angle-right").attr('class', 'admin-arrow fa fa-angle-right active');
        $("#menu-user > .submenu").css('display', 'block');
        $('#menu-user-member > a').attr('class', 'menu-link active')

    });
</script>
