<?php
defined('EM_ROOT') || exit('access denied!');
?>
<style>
.goods-info{
    /*word-wrap: break-word;*/
    /*word-break: break-all;*/
    /*overflow-wrap: break-word;*/
}
</style>


<div style="padding: 20px 0px;">

    <form class="layui-form" style="float: right;">
        <div class="layui-form-item">
            <div class="layui-inline">
                <div class="layui-input-inline layui-input-wrap">
                    <input type="text" value="" name="email_username" placeholder="用户邮箱/账号" lay-affix="clear" class="layui-input">
                </div>
                <div class="layui-input-inline layui-input-wrap">
                    <input type="text" value="" name="out_trade_no" placeholder="订单号" lay-affix="clear" class="layui-input">
                </div>
                <div class="layui-input-inline layui-input-wrap">
                    <input type="text" value="" name="goods_title" placeholder="商品名" lay-affix="clear" class="layui-input">
                </div>
                <div class="layui-input-inline layui-input-wrap">
                    <input type="text" value="" name="client_ip" placeholder="下单IP" lay-affix="clear" class="layui-input">
                </div>
                <div class="layui-input-inline layui-input-wrap">
                    <input type="text" value="" name="order_required" placeholder="下单必填项" lay-affix="clear" class="layui-input">
                </div>
                <div class="layui-form-mid" style="padding: 0!important;">
                    <button class="layui-btn" lay-submit lay-filter="index-search">搜索</button>
                    <button type="reset" class="layui-btn layui-btn-primary">重置</button>
                </div>
            </div>
        </div>

    </form>


    <table class="layui-hide" id="index" lay-filter="index"></table>
</div>
<script type="text/html" id="toolbar">
    <div class="layui-btn-container">
        <button class="layui-btn layui-btn-sm" lay-event="refresh">
            刷新
        </button>
        <button id="toolbar-del" class="layui-btn layui-btn-sm layui-bg-red layui-btn-disabled" lay-event="del">
            删除选中
        </button>
    </div>
</script>
<script type="text/html" id="goods">
    <div class="goods-info">
        <div class="row-1-hidden">{{ d.list[0].title }}</div>
        <div>规格：{{ d.list[0].attr_spec }}</div>
    </div>
</script>

<script type="text/html" id="quantity">
    <div class="goods-info">
        <div>{{ d.list[0].quantity }}</div>
    </div>
</script>
<script type="text/html" id="operate">
    <div class="layui-clear-space">
        <a class="layui-btn layui-btn-xs" lay-event="detail">详情</a>
        {{# if(d.list[0].type == 'xuni' && d.status == '待发货'){ }}
        <a class="layui-btn layui-btn-xs layui-bg-blue" lay-event="deliver">发货</a>
        {{#  } }}
        {{#  if(d.pay_time == ''){ }}
        <a class="layui-btn layui-btn-xs layui-bg-orange" lay-event="budan">补单</a>
        {{#  } }}
        <a class="layui-btn layui-btn-xs layui-bg-red" lay-event="del">删除</a>
    </div>
</script>




<script>
    layui.use(['table'], function(){
        var table = layui.table;
        var form = layui.form;
        // 创建渲染实例
        window.table = table.render({
            elem: '#index',
            autoSort: false,
            url: '?action=index', // 此处为静态模拟数据，实际使用时需换成真实接口
            toolbar: '#toolbar',
            limits: [10,20,30,50,100],
            lineStyle: 'height: 69px;',
            page: true,
            defaultToolbar: ['filter', 'exports', 'print', { // 右上角工具图标
                title: '提示',
                layEvent: 'LAYTABLE_TIPS',
                icon: 'layui-icon-tips',
                onClick: function(obj) { // 2.9.12+
                    layer.alert('自定义工具栏图标按钮');
                }
            }],


            cols: [[
                {type: 'checkbox'},

                {field:'out_trade_no', title: '订单号', width: 180},
                {field:'goods', title:'商品信息',templet: '#goods', minWidth: 200, maxWidth: 500},
                {field:'id', title: '数量', width: 50, templet: '#quantity'},
                {field:'amount', title:'订单金额', width: 100},
                {field:'user_email', title:'用户邮箱', minWidth: 130, maxWidth: 180},
                {field:'status', title:'订单状态', width: 100},
                {field:'payment', title:'支付方式', width: 100},
                {field:'pay_time', title:'支付时间', width: 160},
                {title:'操作', templet: '#operate', minWidth: 168}
            ]],

            error: function(res, msg){
                console.log(res, msg)
            }
        });

        // 搜索提交
        form.on('submit(index-search)', function(data){
            var field = data.field; // 获得表单字段
            // 执行搜索重载
            table.reload('index', {
                page: {
                    curr: 1 // 重新从第 1 页开始
                },
                where: field // 搜索的字段
            });
            return false; // 阻止默认 form 跳转
        });


        // 工具栏事件
        table.on('toolbar(index)', function(obj){
            var id = obj.config.id;
            var checkStatus = table.checkStatus(id);
            var othis = lay(this);
            switch(obj.event){
                case 'refresh':
                    table.reload(id);
                    break;
                case 'del':
                    var data = checkStatus.data;
                    if(data.length == 0){
                        break;
                    }
                    var ids = $.map(data, function(item) {
                        return item.id; // 提取每个对象的uid
                    }).join(',');
                    layer.confirm('确定要删除选中的数据吗？', {
                        btn: ['确认', '取消'], // 按钮
                        icon: 3,             // 图标，3表示问号
                        title: '温馨提示'
                    }, function(index) {
                        layer.close(index); // 关闭对话框
                        $.ajax({
                            url: '?action=del',
                            type: 'POST',
                            dataType: 'json',
                            data: { ids: ids, token: '<?= LoginAuth::genToken() ?>' },
                            success: function(res) {
                                layer.msg('删除成功');
                                table.reload(id);
                            },
                            error: function(err) {
                                layer.msg(err.responseJSON.msg);
                            }
                        });
                    });
                    break;
            };
        });

        // 触发单元格工具事件
        table.on('tool(index)', function(obj){ // 双击 toolDouble
            var data = obj.data; // 获得当前行数据
            var id = obj.config.id;
            if(obj.event == 'del'){
                layer.confirm('确定要删除这条数据吗？', {
                    btn: ['确认', '取消'], // 按钮
                    icon: 3,             // 图标，3表示问号
                    title: '温馨提示'
                }, function(index) {
                    layer.close(index); // 关闭对话框
                    $.ajax({
                        url: '?action=del',
                        type: 'POST',
                        dataType: 'json',
                        data: { ids: data.id, token: '<?= LoginAuth::genToken() ?>' },
                        success: function(res) {
                            layer.msg('删除成功');
                            table.reload(id);
                        },
                        error: function(err) {
                            layer.msg(err.responseJSON.msg);
                        }
                    });
                });
            }
            if(obj.event === 'budan'){
                layer.confirm('将该订单改为已支付状态？', {
                    btn: ['确认', '取消'], // 按钮
                    icon: 3,             // 图标，3表示问号
                    title: '温馨提示'
                }, function(index) {
                    layer.close(index); // 关闭对话框
                    $.ajax({
                        url: '?action=repay',
                        type: 'POST',
                        dataType: 'json',
                        data: { out_trade_no: data.out_trade_no },
                        success: function(res) {
                            layer.msg('补单成功');
                            table.reload(id);
                        },
                        error: function(err) {
                            layer.msg(err.responseJSON.msg);
                        }
                    });
                }, function() {
                });
            }

            if(obj.event === 'deliver'){
                let isMobile = window.innerWidth < 768;
                let area = isMobile ? ['98%', 'auto']  : ['500px', 'auto'];
                layer.open({
                    id: 'deliver',
                    title: '发货信息填写',
                    type: 2,
                    area: area,
                    // skin: 'layui-layer-win10',
                    skin: 'layui-layer-molv',
                    content: 'order.php?action=deliver&order_id=' + data.id,
                    fixed: false, // 不固定
                    maxmin: true,
                    shadeClose: true,
                    success: function(layero, index, that){
                        layer.iframeAuto(index); // 让 iframe 高度自适应
                        that.offset(); // 重新自适应弹层坐标
                    }
                });
            }
            if(obj.event === 'detail'){
                let isMobile = window.innerWidth < 768;
                let area = isMobile ? ['98%', 'auto']  : ['800px', 'auto'];
                layer.open({
                    id: 'detail',
                    title: '订单详情',
                    type: 2,
                    area: area,
                    scrollbar: false,
                    skin: 'layui-layer-molv',
                    content: 'order.php?action=detail&order_id=' + data.id,
                    fixed: false, // 不固定
                    maxmin: true,
                    shadeClose: true,
                    success: function(layero, index, that){
                        layer.iframeAuto(index); // 让 iframe 高度自适应
                        that.offset(); // 重新自适应弹层坐标
                    }
                });
            }
        });

        // 触发排序事件
        table.on('sort(index)', function(obj){
            console.log(obj.field); // 当前排序的字段名
            console.log(obj.type); // 当前排序类型：desc（降序）、asc（升序）、null（空对象，默认排序）
            console.log(this); // 当前排序的 th 对象

            // 尽管我们的 table 自带排序功能，但并没有请求服务端。
            // 有些时候，你可能需要根据当前排序的字段，重新向后端发送请求，从而实现服务端排序，如：
            table.reload('index', {
                initSort: obj, // 记录初始排序，如果不设的话，将无法标记表头的排序状态。
                where: { // 请求参数（注意：这里面的参数可任意定义，并非下面固定的格式）
                    field: obj.field, // 排序字段
                    order: obj.type // 排序方式
                }
            });
        });

        // 触发表格复选框选择
        table.on('checkbox(index)', function(obj){
            var id = obj.config.id;
            var checkData = table.checkStatus(id).data;
            console.log(checkData)
            if(checkData.length == 0){
                $('#toolbar-del').addClass('layui-btn-disabled');
            }else{
                $('#toolbar-del').removeClass('layui-btn-disabled');
            }
        });

        // 分页栏事件
        table.on('pagebar(index)', function(obj){
            alert()
            console.log(obj); // 查看对象所有成员
            console.log(obj.config); // 当前实例的配置信息
            console.log(obj.event); // 属性 lay-event 对应的值
        });


        // 表头自定义元素工具事件 --- 2.8.8+
        table.on('colTool(test)', function(obj){
            var event = obj.event;
            console.log(obj);
            if(event === 'email-tips'){
                layer.alert(layui.util.escape(JSON.stringify(obj.col)), {
                    title: '当前列属性选项'
                });
            }
        });


    });
</script>

<script>


    $(function () {

        $("#menu-order").attr('class', 'admin-menu-item has-list in');
        $("#menu-order .fa-angle-right").attr('class', 'admin-arrow fa fa-angle-right active');
        $("#menu-order > .submenu").css('display', 'block');
        $('#menu-order-goods > a').attr('class', 'menu-link active')



    });
</script>
