<?php defined('EM_ROOT') || exit('access denied!'); ?>

<style>
    table tr:last-child td{
        border-bottom: none;
    }
</style>



<div class="panel bg-white mt-4" style="">
    <div class="panel-body no-padding">

        <div>
            <div class="btn-group">
                <a href="#" class="btn primary btn-sm" data-toggle="modal" data-target="#sortModal"><i class="icon icon-plus"></i> 添加类别</a>
            </div>
        </div>

        <div class="card shadow mb-4">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table custom-table mt-4">
                        <thead>
                        <tr>
                            <th>类别</th>
                            <th>操作</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        foreach ($skus as $key => $val):
                        ?>
                            <tr>
                                <td>
                                    <a href="javascript:;" data-content="<?= $val['name'] ?>" data-id="<?= $val['id'] ?>" class="update-sku"><?= $val['name'] ?></a>
                                </td>
                                <td>
                                    <a href="?action=detail&type_id=<?= $val['id'] ?>">管理</a>

                                    <a href="javascript:;" data-id="<?= $val['id'] ?>" class="del-sku-cate">删除</a>
                                </td>
                            </tr>
                        <?php endforeach ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>



<div class="modal fade" id="sortModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">规格属性</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <form action="sku.php?action=save" method="post" id="sort_new">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="type">类别</label>
                        <input class="form-control" id="type" name="type" required>
                        <small class="form-text text-muted">用于区分不同的规格属性</small>
                    </div>

<!--                    <div class="form-group">-->
<!--                        <label for="sku">规格属性（多个属性之间以换行区分）</label>-->
<!--                        <textarea name="sku" id="sku" type="text" class="form-control" rows="8"></textarea>-->
<!--                        <small class="form-text text-muted">例）颜色@黑色|蓝色|白色</small>-->
<!--                    </div>-->

<!--                    --><?php //doAction('adm_sort_add') ?>
                </div>
                <div class="modal-footer">
                    <input type="hidden" value="" name="sid" id="sid"/>
                    <input name="token" id="token" value="<?= LoginAuth::genToken() ?>" type="hidden"/>
                    <span id="alias_msg_hook"></span>
                    <button type="button" class="btn btn-sm btn-secondary" data-dismiss="modal">取消</button>
                    <button type="submit" id="save_btn" class="btn btn-sm btn-success">保存</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    $(function () {
        $("#menu-goods").attr('class', 'admin-menu-item has-list in');
        $("#menu-goods .fa-angle-right").attr('class', 'admin-arrow fa fa-angle-right active');
        $("#menu-goods > .submenu").css('display', 'block');
        $('#menu-sku-list > a').attr('class', 'menu-link active')


        $('.del-sku-cate').click(function() {
            var id = $(this).data('id');

            layer.confirm('确定要删除这个类别吗？', {icon: 3, title: '温馨提示', skin: 'class-layer-danger', btn: ['确定', '取消']}, function (index) {
                window.location = 'sku.php?action=del_sku_cate&id=' + id;
                layer.close(index);
            });
        })


        $('.update-sku').click(function(){
            var id = $(this).data('id');
            var content = $(this).data('content');

            layer.prompt({
                title: '修改类别名称',
                formType: 0, // 0表示文本框
                value: content
            }, function(value, index, elem){
                window.location = 'sku.php?action=update_sku&id=' + id + '&content=' + value;
                layer.close(index); // 关闭提示框
            });


        })


    });
</script>

<script>
    function issortalias(a) {
        const validChars = /^[\w-]*$/;
        const validDigits = /^\d+$/;
        const reservedKeywords = ['post', 'record', 'sort', 'tag', 'author', 'page', 'posts'];

        if (!validChars.test(a)) return 1;
        if (validDigits.test(a)) return 2;
        if (reservedKeywords.includes(a)) return 3;

        return 0;
    }

    function checksortalias() {
        const alias = $.trim($("#alias").val());
        const saveButton = $("#save_btn");
        const aliasMsgHook = $("#alias_msg_hook");

        const errorMessages = {
            1: '别名错误，应由字母、数字、下划线、短横线组成',
            2: '别名错误，不能为纯数字',
            3: '别名错误，与系统链接冲突'
        };

        const result = issortalias(alias);
        if (result !== 0) {
            saveButton.attr("disabled", "disabled");
            aliasMsgHook.html('<span id="input_error">' + errorMessages[result] + '</span>');
        } else {
            aliasMsgHook.html('');
            $("#msg").html('');
            saveButton.attr("disabled", false);
        }
    }

    // 提交表单
    $("#sort_form").submit(function (event) {
        event.preventDefault();
        submitForm("#sort_form");
    });

    $(function () {
        setTimeout(hideActived, 3600);
        $("#alias").keyup(function () {
            checksortalias();
        });

        $("#menu_category_content").addClass('active');
        $("#menu_content").addClass('show');
        $("#menu_sort").addClass('active');

        // 初始化拖动排序
        $('#dataTable tbody').sortable().disableSelection();

        // 分类编辑
        $('#sortModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var sid = button.data('sid')
            var sortname = button.data('sortname')
            var alias = button.data('alias')
            var description = button.data('description')
            var kw = button.data('kw')
            var title = button.data('title')
            var pid = button.data('pid')
            var template = button.data('template')
            var sortimg = button.data('sortimg')
            var modal = $(this)
            modal.find('.modal-body #sortname').val(sortname)
            modal.find('.modal-body #alias').val(alias)
            modal.find('.modal-body #description').val(description)
            modal.find('.modal-body #kw').val(kw)
            modal.find('.modal-body #title').val(title)
            modal.find('.modal-body #pid').val(pid)
            modal.find('.modal-body #template').val(template)
            modal.find('.modal-body #sortimg').val(sortimg)
            modal.find('.modal-footer #sid').val(sid)
        })
    });
</script>
