<?php defined('EM_ROOT') || exit('access denied!'); ?>



<div class="panel bg-white mt-4">
    <div class="panel-body no-padding">



        <form method="post" id="sort-form" name="addlog" action="sort.php?action=taxis">

            <div>
                <a href="#" class="btn primary btn-sm" data-toggle="modal" data-target="#sortModal"><i class="icon icon-plus"></i> 添加分类</a>
                <button type="submit" value="保存拖动排序" class="btn success btn-sm"><i class="icon icon-arrows"></i> 保存拖动排序</button>
            </div>

            <div class="card shadow mb-4">
                <div class="card-body">
                    <div class="table-responsive table-box" id="adm_sort_list">
                        <table class="table custom-table mt-4" id="dataTable">
                            <thead>
                            <tr>
                                <th>图像</th>
                                <th>名称</th>
                                <th>描述</th>
                                <th>分类ID</th>
                                <th>别名</th>
<!--                                <th>文章</th>-->
                                <th>操作</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                            foreach ($sorts as $key => $value):
                                if ($value['pid'] != 0) {
                                    continue;
                                }
                                ?>
                                <tr style="cursor: move">
                                    <td>
                                        <div class="flex-shrink-0">
                                            <?php if ($value['sortimg']): ?>
                                                <img src="<?= $value['sortimg'] ?>" height="55" class="rounded"/>
                                            <?php else: ?>
                                                <img src="<?= './views/images/null.png' ?>" height="55" class="rounded"/>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td class="sortname">
                                        <input type="hidden" value="<?= $value['sid'] ?>" class="sort_id"/>
                                        <input type="hidden" name="sort[]" value="<?= $value['sid'] ?>"/>
                                        <a href="#"
                                           class="edit-btn"
                                           data-sid="<?= $value['sid'] ?>"
                                           data-sortname="<?= $value['sortname'] ?>"
                                           data-alias="<?= $value['alias'] ?>"
                                           data-description="<?= $value['description'] ?>"
                                           data-kw="<?= $value['kw'] ?>"
                                           data-title="<?= $value['title_origin'] ?>"
                                           data-pid="<?= $value['pid'] ?>"
                                           data-sortimg="<?= $value['sortimg'] ?>"
                                           data-template="<?= $value['template'] ?>"><?= $value['sortname'] ?></a>
                                        <a href="<?= Url::sort($value['sid']) ?>" target="_blank" class="text-muted ml-2"><i class="icofont-external-link"></i></a>
                                    </td>
                                    <td><?= $value['description'] ?></td>
                                    <td><?= $value['sid'] ?></td>
                                    <td class="alias"><?= $value['alias'] ?></td>
<!--                                    <td><a href="article.php?sid=--><?php //= $value['sid'] ?><!--">--><?php //= $value['lognum'] ?><!--</a></td>-->
                                    <td>

                                        <a href="javascript:;" class="btn danger size-sm delete-btn" data-type="<?= $value['type'] ?>" data-id="<?= $value['sid'] ?>">删除</a>
                                    </td>
                                </tr>
                                <?php
                                $children = $value['children'];
                                foreach ($children as $key):
                                    $value = $sorts[$key];
                                    ?>
                                    <tr>
                                        <td>
                                            <div class="flex-shrink-0">
                                                <?php if ($value['sortimg']): ?>
                                                    <img src="<?= $value['sortimg'] ?>" height="55" class="rounded"/>
                                                <?php else: ?>
                                                    <img src="<?= './views/images/null.png' ?>" height="55" class="rounded"/>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                        <td class="sortname">
                                            <input type="hidden" value="<?= $value['sid'] ?>" class="sort_id"/>
                                            <input type="hidden" name="sort[]" value="<?= $value['sid'] ?>"/>
                                            ---- <a href="#"
                                                    class="edit-btn"
                                                    data-sid="<?= $value['sid'] ?>"
                                                    data-sortname="<?= $value['sortname'] ?>"
                                                    data-alias="<?= $value['alias'] ?>"
                                                    data-description="<?= $value['description'] ?>"
                                                    data-kw="<?= $value['kw'] ?>"
                                                    data-title="<?= $value['title_origin'] ?>"
                                                    data-pid="<?= $value['pid'] ?>"
                                                    data-sortimg="<?= $value['sortimg'] ?>"
                                                    data-template="<?= $value['template'] ?>"><?= $value['sortname'] ?></a>
                                            <a href="<?= Url::sort($value['sid']) ?>" target="_blank" class="text-muted ml-2"><i class="icofont-external-link"></i></a>
                                        </td>
                                        <td><?= $value['description'] ?></td>
                                        <td><?= $value['sid'] ?></td>
                                        <td class="alias"><?= $value['alias'] ?></td>
<!--                                        <td><a href="article.php?sid=--><?php //= $value['sid'] ?><!--">--><?php //= $value['lognum'] ?><!--</a></td>-->
                                        <td>
                                            <a href="javascript:;" class="btn danger size-sm delete-btn" data-type="<?= $value['type'] ?>" data-id="<?= $value['sid'] ?>">删除</a>
                                        </td>
                                    </tr>
                                <?php endforeach ?>
                            <?php endforeach ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </form>
    </div>
</div>



<div class="modal fade" id="sortModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">商品分类</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <form action="sort.php?action=save" method="post" id="sort_new">
                <input type="hidden" name="type" value="<?= $type ?>" />
                <div class="modal-body"  style="max-height: 80vh; overflow: auto">
                    <div class="form-group">
                        <label for="sortname">分类名</label>
                        <input class="form-control" id="sortname" name="sortname" required>
                    </div>
                    <div class="form-group">
                        <label for="alias">别名</label>
                        <input class="form-control" id="alias" name="alias">
                        <small class="form-text text-muted">英文字母组成，用于seo设置，可不填</small>
                    </div>
                    <div class="form-group">
                        <label>父分类</label>
                        <select name="pid" id="pid" class="form-control">
                            <option value="0">无</option>
                            <?php
                            foreach ($sorts as $key => $value):
                                if ($value['pid'] != 0) {
                                    continue;
                                }
                                ?>
                                <option value="<?= $key ?>"><?= $value['sortname'] ?></option>
                            <?php endforeach ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="sortimg">分类图像</label>
                        <input name="sortimg" id="sortimg" class="form-control" placeholder="分类图像" value=""/>
                        <div class="row mt-3">
                            <div class="col-md-4">
                                <label for="upload_img">
                                    <img src="./views/images/cover.svg" width="200" id="cover_image" class="rounded" alt="分类图片"/>
                                    <input type="file" name="upload_img" class="image" id="upload_img" style="display:none"/>
                                    <button type="button" id="cover_rm" class="btn-sm btn btn-link">x</button>
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="title">标题（用于分类页的 title）</label>
                        <textarea name="title" id="title" type="text" class="form-control"></textarea>
                        <small class="form-text text-muted">支持变量: {{site_title}}, {{site_name}}, {{sort_name}}</small>
                    </div>
                    <div class="form-group">
                        <label for="alias">描述（用于分类页的 description）</label>
                        <textarea name="description" id="description" type="text" class="form-control"></textarea>
                    </div>
                    <div class="form-group">
                        <label for="kw">关键词（用于分类页的 keywords，英文逗号分割）</label>
                        <textarea name="kw" id="kw" type="text" class="form-control"></textarea>
                    </div>
                    <div class="form-group">
                        <label for="template">分类模板</label>
                        <?php if ($customTemplates):
                            $sortListHtml = '<option value="">默认</option>';
                            foreach ($customTemplates as $v) {
                                $sortListHtml .= '<option value="' . str_replace('.php', '', $v['filename']) . '">' . ($v['comment']) . '</option>';
                            }
                            ?>
                            <select id="template" name="template" class="form-control"><?= $sortListHtml; ?></select>
                            <small class="form-text text-muted">(选择当前模板支持的分类模板，可不选)</small>
                        <?php else: ?>
                            <input class="form-control" id="template" name="template">
                            <small class="form-text text-muted">(用于自定义分类页面模板，对应模板目录下xxx.php文件，xxx即为模板名，可不填)</small>
                        <?php endif; ?>
                    </div>
                    <?php doAction('adm_sort_add') ?>
                </div>
                <div class="modal-footer">
                    <input type="hidden" value="" name="sid" id="sid"/>
                    <input name="token" id="token" value="<?= LoginAuth::genToken() ?>" type="hidden"/>
                    <span id="alias_msg_hook"></span>
                    <button type="button" class="btn btn-sm btn-secondary" data-dismiss="modal">取消</button>
                    <button type="submit" id="save_btn" class="btn btn-sm btn-success">保存</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- 封面图裁剪 -->
<div class="modal fade" id="cover-modal" tabindex="-2" role="dialog" aria-labelledby="modalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">上传封面</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="img-container">
                    <div class="row">
                        <div class="col-md-11">
                            <img src="" id="sample_image"/>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer justify-content-between">
                <div>按住 Shift 等比例调整裁剪区域</div>
                <div>
                    <button type="button" id="hide-modal" class="btn btn-sm btn-secondary" data-dismiss="modal">取消</button>
                    <button type="button" id="crop" class="btn btn-sm btn-success">保存</button>
                    <button type="button" id="use_original_image" class="btn btn-sm btn-google">使用原图</button>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="dropzone-previews" style="display: none;"></div>

<!--<script src="./views/js/dropzone.min.js?t=--><?php //= Option::EM_VERSION_TIMESTAMP ?><!--"></script>-->
<?php if($type == 'goods'): ?>
<script>
    $(function () {
        $("#menu-goods").attr('class', 'admin-menu-item has-list in');
        $("#menu-goods .fa-angle-right").attr('class', 'admin-arrow fa fa-angle-right active');
        $("#menu-goods > .submenu").css('display', 'block');
        $('#menu-sort-list > a').attr('class', 'menu-link active')
    });
</script>
<?php else: ?>
    <script>
        $(function () {
            $("#menu-blog").attr('class', 'admin-menu-item has-list in');
            $("#menu-blog .fa-angle-right").attr('class', 'admin-arrow fa fa-angle-right active');
            $("#menu-blog > .submenu").css('display', 'block');
            $('#menu-blog-sort > a').attr('class', 'menu-link active')
        });
    </script>
<?php endif; ?>

<script>

    // 提交表单
    $("#sort-form").submit(function (event) {
        event.preventDefault();
        $.ajax({
            type: "POST",
            url: $('#sort-form').attr('action'),
            data: $('#sort-form').serialize(),
            dataType: "json",
            success: function (e) {
                layer.msg('排序保存成功');
            },
            error: function (xhr) {
                const errorMsg = JSON.parse(xhr.responseText).msg;
                layer.msg(errorMsg)
            }
        });
    });


    $('.delete-btn').click(function() {
        // 获取要删除的记录ID
        var id = $(this).data('id');
        var type = $(this).data('type');

        // 调用layer.confirm确认弹窗
        layer.confirm('确定要删除这条记录吗？此操作不可恢复！', {
            icon: 3,
            title: '确认删除',
            btn: ['确认删除', '取消'] // 按钮
        }, function(index) {
            // 确认删除时的操作
            location.href="sort.php?action=del&sid=" + id + "&type=" + type
        }, function() {
            // 取消删除时的操作
        });
    });








    function issortalias(a) {
        const validChars = /^[\w-]*$/;
        const validDigits = /^\d+$/;
        const reservedKeywords = ['post', 'record', 'sort', 'tag', 'author', 'page', 'posts'];

        if (!validChars.test(a)) return 1;
        if (validDigits.test(a)) return 2;
        if (reservedKeywords.includes(a)) return 3;

        return 0;
    }

    function checksortalias() {
        const alias = $.trim($("#alias").val());
        const saveButton = $("#save_btn");
        const aliasMsgHook = $("#alias_msg_hook");

        const errorMessages = {
            1: '别名错误，应由字母、数字、下划线、短横线组成',
            2: '别名错误，不能为纯数字',
            3: '别名错误，与系统链接冲突'
        };

        const result = issortalias(alias);
        if (result !== 0) {
            saveButton.attr("disabled", "disabled");
            aliasMsgHook.html('<span id="input_error">' + errorMessages[result] + '</span>');
        } else {
            aliasMsgHook.html('');
            $("#msg").html('');
            saveButton.attr("disabled", false);
        }
    }

    // 提交表单
    $("#sort_form").submit(function (event) {
        event.preventDefault();
        submitForm("#sort_form");
    });

    $(function () {
        setTimeout(hideActived, 3600);
        $("#alias").keyup(function () {
            checksortalias();
        });

        $("#menu_category_content").addClass('active');
        $("#menu_content").addClass('show');
        $("#menu_sort").addClass('active');

        // 初始化拖动排序
        $('#dataTable tbody').sortable().disableSelection();

        // 分类编辑
        $('.edit-btn').click(function(){
            var button = $(this)
            var sid = button.data('sid')
            var sortname = button.data('sortname')
            var alias = button.data('alias')
            var description = button.data('description')
            var kw = button.data('kw')
            var title = button.data('title')
            var pid = button.data('pid')
            var template = button.data('template')
            var sortimg = button.data('sortimg')
            $('.modal-body #sortname').val(sortname)
            $('.modal-body #alias').val(alias)
            $('.modal-body #description').val(description)
            $('.modal-body #kw').val(kw)
            $('.modal-body #title').val(title)
            $('.modal-body #pid').val(pid)
            $('.modal-body #template').val(template)
            $('.modal-body #sortimg').val(sortimg)

            if(sortimg){
                $('#cover_image').attr('src', sortimg);
                $('#cover_rm').show();
            }else{
                $('#cover_image').attr('src', './views/images/cover.svg');
                $('#cover_rm').hide();
            }

            $('.modal-footer #sid').val(sid)

            zui.Modal.open({id:'sortModal'})

        })
        $('#sortModal').on('show.bs.modal', function (event) {

        })

        // 封面图
        var $modal = $('#cover-modal');
        var image = document.getElementById('sample_image');
        var cropper;
        $('#upload_img').change(function (event) {
            var files = event.target.files;
            var done = function (url) {
                image.src = url;
                zui.Modal.open({id:'cover-modal'})
            };
            if (files && files.length > 0) {
                if (!files[0].type.startsWith('image')) {
                    alert('只能上传图片');
                    return;
                }
                reader = new FileReader();
                reader.onload = function (event) {
                    done(reader.result);
                };
                reader.readAsDataURL(files[0]);
            }
        });
        $modal.on('shown.bs.modal', function () {
            cropper = new Cropper(image, {
                aspectRatio: NaN,
                viewMode: 1
            });
        }).on('hidden.bs.modal', function () {
            cropper.destroy();
            cropper = null;
        });

        // 上传图片
        function uploadImage(blob, filename) {
            var formData = new FormData();
            formData.append('image', blob, filename);
            $.ajax('./article.php?action=upload_cover', {
                method: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function (data) {
                    $('#hide-modal').click()
                    if (data.code == 0) {
                        $('#cover_image').attr('src', data.data);
                        $('#sortimg').val(data.data);
                        $('#cover_rm').show();
                    } else {
                        alert(data.msg);
                    }
                },
                error: function (xhr) {
                    var data = xhr.responseJSON;
                    if (data && typeof data === "object") {
                        alert(data.msg);
                    } else {
                        alert("上传封面出错了");
                    }
                }
            });
        }

        $('#crop').click(function () {
            canvas = cropper.getCroppedCanvas({
                width: 650,
                height: 366
            });
            canvas.toBlob(function (blob) {
                uploadImage(blob, 'cover.jpg')
            });
        });

        $('#use_original_image').click(function () {
            var blob = $('#upload_img')[0].files[0];
            uploadImage(blob, blob.name)
        });

        $('#cover_rm').click(function () {
            $('#cover_image').attr('src', "./views/images/cover.svg");
            $('#sortimg').val("");
            $('#cover_rm').hide();
        });

        $('#sortimg').blur(function () {
                c = $('#sortimg').val();
                if (!c) {
                    $('#cover_image').attr('src', "./views/images/cover.svg");
                    $('#cover_rm').hide();
                    return
                }
                $('#sortimg').attr('src', c);
                $('#cover_rm').show();
            }
        );


    });
</script>
