<?php defined('EM_ROOT') || exit('access denied!'); ?>

<?php if (isset($_GET['activate_install'])): ?>
    <div class="alert alert-success">模板安装成功</div><?php endif ?>
<?php if (isset($_GET['activate_upgrade'])): ?>
    <div class="alert alert-success">模板更新成功</div><?php endif ?>
<?php if (isset($_GET['activate_del'])): ?>
    <div class="alert alert-success">删除模板成功</div><?php endif ?>
<?php if (isset($_GET['error_f'])): ?>
    <div class="alert alert-danger">删除失败，请检查模板文件权限</div><?php endif ?>
<?php if (!$nonce_template_data): ?>
    <div class="alert alert-danger">当前使用的模板(<?= $nonce_template ?>)已被删除或损坏，请选择其他模板。</div><?php endif ?>
<?php if (isset($_GET['error_a'])): ?>
    <div class="alert alert-danger">只支持zip压缩格式的模板包</div><?php endif ?>
<?php if (isset($_GET['error_b'])): ?>
    <div class="alert alert-danger">上传失败，模板目录(content/templates)不可写</div><?php endif ?>
<?php if (isset($_GET['error_d'])): ?>
    <div class="alert alert-danger">请选择一个zip格式的模板安装包</div><?php endif ?>
<?php if (isset($_GET['error_e'])): ?>
    <div class="alert alert-danger">安装失败，模板安装包不符合标准</div><?php endif ?>
<?php if (isset($_GET['error_f'])): ?>
    <div class="alert alert-danger">上传安装包大小超出PHP限制</div><?php endif ?>
<?php if (isset($_GET['error_c'])): ?>
    <div class="alert alert-danger">服务器PHP不支持zip模块</div><?php endif ?>
<?php if (isset($_GET['error_h'])): ?>
    <div class="alert alert-danger">更新失败，无法下载更新包，可能是服务器网络问题。</div><?php endif ?>
<?php if (isset($_GET['error_i'])): ?>
    <div class="alert alert-danger">您的emshop未授权</div><?php endif ?>


<style>
    .app-list .card.mb-4.shadow-sm{
        border: 2px solid #909090;
    }
    .template-preview {
        display: block;
        overflow: hidden;
    }

    .template-preview img {
        transition: transform 0.3s ease;
    }

    .template-preview:hover img {
        transform: scale(1.05);
    }
    .vtpl-header-inner{
        display: flex;
    }
    .vtpl-nav ul{
        margin: 0;
        padding-left: 0;
    }
</style>

<div class="panel shadow mt-4 bg-white">
    <div class="panel-body">
        <a href="store.php?action=tpl"  class="btn btn-sm primary  shadow-sm mb-4 mt-1"><i class="fa fa-cart-plus"></i> 应用商店</a>

        <div id="content">
            <div class="container-fluid">

                <div class="row app-list" style="margin-left: 0; margin-right: 0;">

                    <div class="grid-cols-lg-3 grid-gap-15 grid-cols-md-2 grid-cols-sm-2 grid-cols-xl-4  ">
                        <?php foreach ($templates as $key => $value): ?>
                            <div class="template-panel panel bg-white shadow <?= $nonce_template == $value['tplfile'] ? 'active' : '' ?>">
                                <div class="panel-body" data-app-alias="<?= $value['tplfile'] ?>" data-app-version="<?= $value['version'] ?>">
                                    <div class="alert mb-3 <?php if ($nonce_template == $value['tplfile']) {
                                        echo "bg-primary text-white font-weight-bold";
                                    } ?>">
                                        <?= $value['tplname'] ?>
                                    </div>


                                    <div class="card-body">
                                        <a href="template.php?action=use&tpl=<?= $value['tplfile'] ?>&token=<?= LoginAuth::genToken() ?>">
                                            <img class="card-img-top" src="<?= $value['preview'] ?>" alt="preview image">
                                        </a>
                                    </div>
                                    <div class="card-footer">
                                        <?php if ($value['version']): ?>
                                            <div class="small">版本号：<?= $value['version'] ?></div>
                                        <?php endif ?>
                                        <?php if ($value['author'] && strpos($value['author_url'], 'https://www.baidu.com') === 0): ?>
                                            <div class="small">开发者：<a href="<?= $value['author_url'] ?>" target="_blank"><?= $value['author'] ?></a></div>
                                        <?php elseif ($value['author']): ?>
                                            <div class="small">开发者：<?= $value['author'] ?></div>
                                        <?php endif ?>

                                        <div class="card-text d-flex justify-content-between mt-3">
                        <span>
                        <?php if ($nonce_template !== $value['tplfile']): ?>
                            <a class="btn primary-pale mr-2 btn-sm" href="template.php?action=use&tpl=<?= $value['tplfile'] ?>&token=<?= LoginAuth::genToken() ?>">启用</a>
                        <?php else: ?>
                            <a class="btn primary-pale mr-2 btn-sm disabled" href="javascript:;">启用</a>
                        <?php endif; ?>
                            <span class="setting-btn"></span>
                        </span>
                                            <span>
                            <a class="btn danger-pale btn-sm" href="javascript: eb_confirm('<?= $value['tplfile'] ?>', 'tpl', '<?= LoginAuth::genToken() ?>');">删除</a>
                        </span>

                                            <span class="update-btn"></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach ?>
                    </div>
                </div>



            </div>
        </div>





        <div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">安装模板</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="./template.php?action=upload_zip" method="post" enctype="multipart/form-data">
                        <div class="modal-body">
                            <div>
                                <p>上传一个zip压缩格式的模板安装包</p>
                                <p>
                                    <input name="token" id="token" value="<?= LoginAuth::genToken() ?>" type="hidden"/>
                                    <input name="tplzip" type="file"/>
                                </p>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-sm btn-secondary" data-dismiss="modal">取消</button>
                            <button type="submit" class="btn btn-sm btn-success">上传</button>
                            <span id="alias_msg_hook"></span>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>



<script>
    // check for upgrade
    $(function () {
        setTimeout(hideActived, 3600);



        $("#menu-appearance").attr('class', 'admin-menu-item has-list in');
        $("#menu-appearance .fa-angle-right").attr('class', 'admin-arrow fa fa-angle-right active');
        $("#menu-appearance > .submenu").css('display', 'block');
        $('#menu-template > a').attr('class', 'menu-link active')

        var templateList = [];
        $('.app-list .panel-body').each(function () {
            var $card = $(this);
            var alias = $card.data('app-alias');
            var version = $card.data('app-version');
            templateList.push({
                name: alias,
                version: version
            });
        });
        $.ajax({
            url: './template.php?action=check_update',
            type: 'POST',
            data: {
                templates: templateList
            },
            success: function (response) {
                if (response.code === 0) {
                    var pluginsToUpdate = response.data;
                    $.each(pluginsToUpdate, function (index, item) {
                        var $tr = $('.app-list .panel-body[data-app-alias="' + item.name + '"]');
                        var $updateBtn = $tr.find('.update-btn');
                        $updateBtn.append($('<a>').addClass('btn success btn-sm ml-2').text('更新模板').attr("href", "./template.php?action=upgrade&alias=" + item.name));
                    });
                } else {
                    console.log('更新接口返回错误');
                }
            },
            error: function () {
                console.log('请求更新接口失败');
            }
        });
    });
</script>
