<?php

defined('EM_ROOT') || exit('access denied!');
require_once View::getView('module');
$version = '1720327727';
if (!function_exists('_g')) {
    emMsg('请开启【模板设置】插件, <a href="/admin/plugin.php">去开启</a>');
}
?>
<!doctype html>
<html lang="zh-cn" data-theme="light">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?= $site_title ?></title>
    <meta name="keywords" content="<?= $site_key ?>"/>
    <meta name="description" content="<?= $site_description ?>"/>
    <link href="<?= empty(_g('favicon')) ? EM_URL . 'favicon.ico' : _g('favicon'); ?>" rel="icon">
    <link rel="alternate" title="RSS" href="<?= EM_URL ?>rss.php" type="application/rss+xml"/>

    <link rel="stylesheet" href="../../../admin/views/css/bootstrap.min.css">

    <script src="../../../admin/views/js/jquery.min.3.5.1.js"></script>
    <script src="../../../admin/views/js/bootstrap.bundle.min.4.6.js?t=<?= Option::EM_VERSION_TIMESTAMP ?>"></script>
    <!-- 字体 -->
    <link rel="stylesheet" type="text/css" href="../../../admin/views/font-awesome-4.7.0/css/font-awesome.min.css">


    <link rel="stylesheet" href="<?= TEMPLATE_URL ?>/layui/css/layui.css">
    <link href="<?= TEMPLATE_URL ?>css/style.css?v=<?= time() ?>" rel="stylesheet"/>


    <script src="<?= TEMPLATE_URL ?>js/zoom.js?v=<?= $version ?>&t=<?= Option::EM_VERSION_TIMESTAMP ?>"></script>

    <style>
        body{
            background: #f7f7f7;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            word-break: break-all;
        }
        .container{
            flex-grow: 1;
            padding-left: 15px;
            padding-right: 15px;
        }
        .navbar-default{
            background: #fff;
            height: 50px;
        }

        .navbar-brand{
            height: 50px;
            padding: 12px 15px 14px 0;
        }

        @media (min-width: 992px){
            .navbar-nav>li>a{
                padding-top: 14px;
                padding-bottom: 14px;
            }
        }



        /* 商品列表的样式 */


        /* 卡片样式 - 白色背景 + 阴影 + 圆角 */
        .card {
            background: #fff;
            border: unset;
            border-radius: 4px !important;
            overflow: hidden;
            text-decoration: none;
            color: #333;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.05)!important;
            transition: box-shadow 0.3s;

        }

        .card:hover {
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.25);
            text-decoration: none;
        }

        /* 图片容器 - 新增 */
        .goods-img-container {
            width: 100%;
            aspect-ratio: 1 / 1;
            overflow: hidden; /* 关键：确保图片放大不超出 */
            position: relative;
            background: #f5f5f5;
        }

        /* 封面图（保持正方形） */
        .goods-cover {
            width: 100%;
            height: 100%;
            object-fit: cover;
            object-position: center;
            transition: transform 0.3s ease;
            transform-origin: center center; /* 从中心点放大 */
            aspect-ratio: 1 / 1;
        }



        /* 文字内容区域 */


        .card-content, .card-actions {
            padding: 0 8px 3px !important;
        }

        /* 价格样式 */
        .text-danger {
            color: #ff4d4f !important;
        }
        .market-price {
            color: #999;
            margin-left: 5px;
        }

        .mobile-search-order-btn {
            display: none;
            height: 38px;
            text-align: center;
            text-decoration: none;
            text-transform: uppercase;
            font-size: 16px;
            color: #fff;
            border-radius: 5px;
            background-image: linear-gradient(to right, #03a9f4, #f441a5, #ffeb3b, #09a8f4);
            padding: 6px 20px;
            background-size: 400%;
            line-height: 28px;
            margin-right: 3px;
        }

        @media (max-width: 850px) {
            .mobile-search-order-btn {
                display: block;
            }
        }

        iframe{
            max-width: 100%!important;
        }


    </style>


    <?php doAction('index_head') ?>
    <script>
        // 日历生成和翻页
        function sendinfo(url) {
            $("#calendar").load(url)
        }

        // 切换夜间模式主题
        const savedTheme = localStorage.getItem('theme');
        if (savedTheme) {
            document.documentElement.setAttribute('data-theme', savedTheme);
        }
    </script>
</head>
<body>

<nav class="navbar navbar-expand-md navbar-light bg-white shadow-sm fixed-top transition-all duration-300" id="mainNav">
    <div class="container">
        <!-- 品牌标识 -->
        <a class="navbar-brand font-weight-bold text-primary" href="<?= EM_URL ?>">
            <span class="" style="font-size: 1.55rem; "><?= $blogname ?></span>
        </a>

        <a class="ml-auto mobile-search-order-btn" href="<?= EM_URL ?>user/order.php?action=search">查询订单</a>

        <!-- 移动端菜单按钮 -->
        <button class="navbar-toggler border-0" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>

        <!-- 导航项目 -->
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav mr-auto">
                <?php blog_navi() ?>
            </ul>

            <ul class="navbar-nav align-items-center">

                <li class="nav-item dropdown mr-3">

                    <div class="dropdown-menu dropdown-menu-right shadow-lg border-0 rounded-lg animate slideIn"
                         aria-labelledby="navbarDropdown">
                        <?php if(ISLOGIN): ?>
                            <a class="dropdown-item py-2" href="<?= EM_URL ?>user/order.php">
                                <i class="fa fa-shopping-bag mr-2"></i>我的订单
                            </a>
                            <a class="dropdown-item py-2" href="<?= EM_URL ?>user/order.php?action=search">
                                <i class="fa fa-shopping-bag mr-2"></i>游客查单
                            </a>
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item py-2 text-danger" href="<?= EM_URL ?>user/account.php?action=logout">
                                <i class="fa fa-sign-out mr-2"></i>退出登录
                            </a>
                        <?php else: ?>

                        <?php endif; ?>

                    </div>
                </li>

            </ul>
            <?php if(ISLOGIN): ?>
                <div class="btn-group mr-3" role="group" aria-label="Basic example">
                    <a type="button" class="btn btn-info" href="<?= EM_URL ?>user">
                        <i class="fa fa-user mr-2"></i>个人中心
                    </a>
                    <a type="button" class="btn btn-warning" href="<?= EM_URL ?>user/account.php?action=logout">
                        <i class="fa fa-sign-out mr-2"></i>退出登录
                    </a>
                </div>
            <?php else: ?>


                <div class="btn-group mr-3" role="group" aria-label="Basic example">
                    <?php if(Option::get('login_switch') == 'y'): ?>
                        <a type="button" class="btn btn-info" href="<?= EM_URL ?>user">
                            <i class="fa fa-sign-in mr-2"></i>登录
                        </a>
                    <?php endif; ?>
                    <?php if(Option::get('register_switch') == 'y'): ?>
                        <a type="button" class="btn btn-warning" href="<?= EM_URL ?>user/account.php?action=signup">
                            <i class="fa fa-user-plus mr-2"></i>注册
                        </a>
                    <?php endif; ?>
                </div>
                <a type="button" href="<?= EM_URL ?>user/order.php?action=search" class="btn btn-outline-primary">
                    <i class="fa fa-search"></i> 游客查单
                </a>
            <?php endif; ?>

        </div>
    </div>
</nav>
<style>
    /* 电脑端下拉菜单悬浮显示 */
    @media (min-width: 992px) {
        .navbar-nav .dropdown:hover .dropdown-menu {
            display: block;
            opacity: 1;
            transform: translateY(0);
        }

        .navbar-nav .dropdown .dropdown-menu {
            display: none;
            transition: all 0.3s ease;
            opacity: 0;
            transform: translateY(5px);
        }

        .dropdown-toggle::after {
            display: none; /* 隐藏默认下拉箭头 */
        }

        /* 自定义下拉箭头 */
        .dropdown .nav-link::after {
            content: "\f107"; /* Font Awesome下箭头图标 */
            font-family: "Font Awesome 5 Free";
            font-weight: 900;
            margin-left: 4px;
            font-size: 0.875rem;
        }
    }

    /* 导航栏滚动效果 */
    #mainNav {
        transition: all 0.3s ease;
    }

    #mainNav.scrolled {
        background-color: rgba(255, 255, 255, 0.95);
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
        padding-top: 0.5rem;
        padding-bottom: 0.5rem;
    }

    /* 下拉菜单动画 */
    .animate {
        animation-name: slideIn;
        animation-duration: 0.3s;
        animation-fill-mode: both;
    }

    @keyframes slideIn {
        0% {
            transform: translateY(10px);
            opacity: 0;
        }
        100% {
            transform: translateY(0);
            opacity: 1;
        }
    }

    /* 搜索框样式 */
    .input-group-rounded-pill {
        border-radius: 50rem;
    }

    /* 导航项悬停效果 */
    .navbar-nav .nav-link {
        position: relative;
        transition: all 0.3s ease;
    }

    .navbar-nav .nav-link:hover {
        color: #007bff !important;
    }

    .navbar-nav .nav-link::after {
        content: '';
        position: absolute;
        width: 0;
        height: 2px;
        bottom: -2px;
        left: 0;
        background-color: #007bff;
        transition: width 0.3s ease;
    }

    .navbar-nav .nav-link:hover::after {
        width: 100%;
    }
</style>

<script>
    // 导航栏滚动效果
    window.addEventListener('scroll', function() {
        const nav = document.getElementById('mainNav');
        if (window.scrollY > 50) {
            nav.classList.add('scrolled');
        } else {
            nav.classList.remove('scrolled');
        }
    });

    // 移动端下拉菜单点击处理（保持原有逻辑）
    $(document).ready(function() {
        if ($(window).width() < 992) {
            $('.dropdown-toggle').on('click', function(e) {
                e.preventDefault();
                $(this).next('.dropdown-menu').toggleClass('show');
            });
        }
    });

    // 平滑滚动
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            document.querySelector(this.getAttribute('href')).scrollIntoView({
                behavior: 'smooth'
            });
        });
    });
</script>