<?php defined('EM_ROOT') || exit('access denied!'); ?>

<style>
    body {
        background: #f8f9fa;
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 20px;
    }
    .card {
        border-radius: 15px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        border: none;
        transition: all 0.3s ease;
    }
    .card:hover {
        box-shadow: 0 15px 35px rgba(0,0,0,0.15);
    }
    .card-header {
        background: linear-gradient(135deg, #3B82F6, #2563EB);
        color: white;
        border-radius: 15px 15px 0 0 !important;
        padding: 20px;
        text-align: center;
        font-size: 24px;
        font-weight: 600;
    }
    .form-control {
        border-radius: 8px;
        padding: 12px 15px;
        border: 1px solid #e2e8f0;
        transition: border-color 0.2s, box-shadow 0.2s;
    }
    .form-control:focus {
        border-color: #3B82F6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.3);
        outline: none;
    }
    .btn-primary {
        background: linear-gradient(135deg, #3B82F6, #2563EB);
        border: none;
        border-radius: 8px;
        padding: 12px;
        font-size: 18px;
        font-weight: 500;
        transition: all 0.3s ease;
    }
    .btn-primary:hover {
        background: linear-gradient(135deg, #3B82F6, #2563EB);
        transform: translateY(-2px);
    }
    .btn-primary:active {
        transform: translateY(0);
    }
    .btn-success {
        background: linear-gradient(135deg, #3B82F6, #2563EB);
        border: none;
        border-radius: 8px;
        padding: 10px 15px;
        font-size: 16px;
        font-weight: 500;
        transition: all 0.3s ease;
    }
    .btn-success:hover {
        background: linear-gradient(135deg, #2563EB, #1D4ED8);
        transform: translateY(-2px);
    }
    .btn-success:active {
        transform: translateY(0);
    }
    .btn-success:disabled {
        background: #94A3B8;
        cursor: not-allowed;
        transform: none;
    }
    .alert {
        border-radius: 8px;
        padding: 12px 15px;
        margin-bottom: 20px;
    }
    .custom-control-label {
        cursor: pointer;
    }
    .login-options {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-top: 15px;
    }
    .login-options a {
        color: #64748B;
        transition: color 0.2s;
    }
    .login-options a:hover {
        color: #3B82F6;
    }
    .login-links {
        display: flex;
        justify-content: center;
        gap: 20px;
        margin-top: 20px;
    }
    .login-links a {
        color: #64748B;
        text-decoration: none;
        transition: color 0.2s;
    }
    .login-links a:hover {
        color: #3B82F6;
        text-decoration: underline;
    }
    .checkcode-container {
        display: flex;
        align-items: center;
        gap: 10px;
    }
    #checkcode {
        border-radius: 8px;
        cursor: pointer;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        transition: transform 0.2s;
    }
    #checkcode:hover {
        transform: scale(1.02);
    }
    .form-group {
        margin-bottom: 1.5rem;
    }
</style>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-xl-5 col-lg-6 col-md-8 col-sm-8 col-12">
            <div class="card">
                <div class="card-header">
                    <i class="fa fa-user-plus mr-2"></i>用户注册
                </div>
                <div class="card-body p-5">
                    <!-- 提示信息 -->
                    <div class="alert alert-danger alert-dismissible fade show" style="display: none;" id="send-btn-resp">
                        <button type="button" class="close" data-dismiss="alert">&times;</button>
                        <i class="fa fa-exclamation-circle mr-2"></i><span id="resp-message"></span>
                    </div>

                    <?php if (isset($_GET['err_ckcode'])): ?>
                        <div class="alert alert-danger alert-dismissible fade show">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            <i class="fa fa-exclamation-circle mr-2"></i>图形验证错误
                        </div>
                    <?php endif ?>

                    <?php if (isset($_GET['err_mail_code'])): ?>
                        <div class="alert alert-danger alert-dismissible fade show">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            <i class="fa fa-exclamation-circle mr-2"></i>邮件验证码错误
                        </div>
                    <?php endif ?>

                    <?php if (isset($_GET['error_login'])): ?>
                        <div class="alert alert-danger alert-dismissible fade show">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            <i class="fa fa-exclamation-circle mr-2"></i>错误的邮箱格式
                        </div>
                    <?php endif ?>

                    <?php if (isset($_GET['error_exist'])): ?>
                        <div class="alert alert-danger alert-dismissible fade show">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            <i class="fa fa-exclamation-circle mr-2"></i>该邮箱已被注册
                        </div>
                    <?php endif ?>

                    <?php if (isset($_GET['error_pwd_len'])): ?>
                        <div class="alert alert-danger alert-dismissible fade show">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            <i class="fa fa-exclamation-circle mr-2"></i>密码不小于6位
                        </div>
                    <?php endif ?>

                    <?php if (isset($_GET['error_pwd2'])): ?>
                        <div class="alert alert-danger alert-dismissible fade show">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            <i class="fa fa-exclamation-circle mr-2"></i>两次输入的密码不一致
                        </div>
                    <?php endif ?>

                    <form method="post" class="user" action="./account.php?action=dosignup">
                        <div class="form-group">
                            <label for="mail" class="sr-only">邮箱</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><i class="fa fa-envelope-o fa-fw"></i></span>
                                </div>
                                <input type="email" class="form-control" id="mail" name="mail" placeholder="邮箱" required autofocus>
                            </div>
                            <small class="form-text text-muted mt-1">我们不会向您发送垃圾邮件</small>
                        </div>

                        <div class="form-group">
                            <label for="passwd" class="sr-only">密码</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><i class="fa fa-lock fa-fw"></i></span>
                                </div>
                                <input type="password" class="form-control" minlength="6" id="passwd" autocomplete="new-password" name="passwd" placeholder="密码" required>
                            </div>
                            <small class="form-text text-muted mt-1">密码长度至少为6位</small>
                        </div>

                        <div class="form-group">
                            <label for="repasswd" class="sr-only">确认密码</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><i class="fa fa-lock fa-fw"></i></span>
                                </div>
                                <input type="password" class="form-control" minlength="6" id="repasswd" name="repasswd" placeholder="再次输入密码" required>
                            </div>
                        </div>

                        <?php if ($email_code): ?>
                            <div class="form-group">
                                <label for="mail_code" class="sr-only">邮件验证码</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fa fa-envelope-o"></i></span>
                                    </div>
                                    <input type="text" name="mail_code" class="form-control flex-grow-1" id="mail_code" placeholder="邮件验证码" required>
                                    <div class="input-group-append">
                                        <button class="btn btn-success" type="button" id="send-btn">
                                            <i class="fa fa-paper-plane mr-1"></i>发送验证码
                                        </button>
                                    </div>
                                </div>
                                <small class="form-text text-muted mt-1">请输入邮箱收到的验证码</small>
                            </div>
                        <?php endif ?>

                        <?php if ($login_code): ?>
                            <div class="form-group">
                                <label for="login_code" class="sr-only">图形验证码</label>
                                <div class="checkcode-container">
                                    <div class="input-group flex-grow-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><i class="fa fa-shield"></i></span>
                                        </div>
                                        <input type="text" name="login_code" class="form-control" id="login_code" placeholder="验证码" required>
                                    </div>
                                    <img src="../include/lib/checkcode.php" id="checkcode" onclick="this.src='../include/lib/checkcode.php?'+Math.random()">
                                </div>
                                <small class="form-text text-muted mt-1">点击图片可刷新验证码</small>
                            </div>
                        <?php endif ?>

                        <button type="submit" class="btn btn-primary btn-block">
                            <i class="fa iconfont icon-zhuceyaoqing mr-2"></i>立即注册
                        </button>

                        <hr class="my-4">

                        <div class="text-center">
                            <a href="./" class="text-primary">
                                <i class="fa iconfont icon-denglu mr-1"></i>已有账号？立即登录
                            </a>
                        </div>

                        <div class="text-center mt-4">
                            <?php doAction('signup_ext') ?>
                        </div>

                        <hr class="my-4">

                        <div class="text-center">
                            <a href="../" class="text-muted">
                                <i class="fa fa-home mr-1"></i>返回首页
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

</div>
</body>
</html>
<script>
    // send mail code
    $(function () {
        setTimeout(hideActived, 6000);
        $('#checkcode').click(function () {
            var timestamp = new Date().getTime();
            $(this).attr("src", "../include/lib/checkcode.php?" + timestamp);
        });

        $('#send-btn').click(function () {
            const email = $('#mail').val();
            const sendBtn = $(this);
            const sendBtnResp = $('#send-btn-resp');
            sendBtnResp.html('')
            sendBtn.prop('disabled', true);
            $.ajax({
                type: 'POST',
                url: './account.php?action=send_email_code',
                data: {
                    mail: email
                },
                success: function (response) {
                    // 发送邮件成功后，启动倒计时
                    let seconds = 60;
                    // 启动倒计时
                    const countdownInterval = setInterval(() => {
                        seconds--;
                        if (seconds <= 0) {
                            clearInterval(countdownInterval);
                            sendBtn.html('发送邮件验证码');
                            sendBtn.prop('disabled', false);
                        } else {
                            sendBtn.html('已发送,请查收邮件 ' + seconds + '秒');
                        }
                    }, 1000);
                },
                error: function (data) {
                    sendBtnResp.html(data.responseJSON.msg).addClass('text-danger').show()
                    sendBtn.prop('disabled', false);
                }
            });
        });
    });
</script>
