<?php defined('EM_ROOT') || exit('access denied!'); ?>

<div style="padding: 20px 0px;">
    <div class="layui-tabs" style="margin-bottom: 12px;" lay-options="{trigger: false}">
        <ul class="layui-tabs-header">
            <li><a href="./setting.php">基础设置</a></li>
            <li><a href="./setting.php?action=user">用户设置</a></li>
            <li><a href="./setting.php?action=seo">SEO设置</a></li>
            <li class="layui-this"><a href="./setting.php?action=mail">邮箱配置</a></li>
            <li><a href="./blogger.php">个人信息</a></li>
        </ul>
    </div>
    <div class="layui-panel">
        <div style="padding: 20px;">
            <form action="setting.php?action=mail_save" method="post" name="setting_form" id="setting_form" class="layui-form">

                <div class="layui-form-item">
                    <label class="layui-form-label">发送人邮箱</label>
                    <div class="layui-input-block">
                        <input type="email" class="layui-input" value="<?= $smtp_mail ?>" name="smtp_mail">
                    </div>
                </div>
                <div class="layui-form-item">
                    <label class="layui-form-label">SMTP密码</label>
                    <div class="layui-input-block">
                        <input type="text" name="smtp_pw" class="layui-input" value="<?= $smtp_pw ?>" autocomplete="new-password">
                    </div>
                </div>
                <div class="layui-form-item">
                    <label class="layui-form-label">发送人名称（选填，建议填写站点名称）</label>
                    <div class="layui-input-block">
                        <input type="from_name" class="layui-input" value="<?= $smtp_from_name ?>" name="smtp_from_name">
                    </div>
                </div>
                <div class="layui-form-item">
                    <label class="layui-form-label">SMTP服务器</label>
                    <div class="layui-input-block">
                        <input class="layui-input" value="<?= $smtp_server ?>" name="smtp_server">
                    </div>
                </div>
                <div class="layui-form-item">
                    <label class="layui-form-label">端口 (465：ssl协议，如QQ邮箱，网易邮箱等，587：STARTTLS协议 如：Outlook邮箱)</label>
                    <div class="layui-input-block">
                        <input class="layui-input" value="<?= $smtp_port ?>" name="smtp_port">
                    </div>
                </div>

                <div class="layui-form-item">
                    <blockquote class="layui-elem-quote">
                        <b>以QQ邮箱配置为例</b><br>
                        发送人邮箱：你的QQ邮箱<br>
                        SMTP密码：见QQ邮箱顶部设置-> 账户 -> 开启IMAP/SMTP服务 -> 生成授权码（即为SMTP密码）<br>
                        发送人名称：你的姓名或者站点名称<br>
                        SMTP服务器：smtp.qq.com<br>
                        端口：465<br>
                    </blockquote>
                </div>

                <!-- 设置接收邮箱的模态框 -->
                <div class="modal fade" id="testMail">
                    <div class="modal-dialog modal-sm">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title">发送测试</h4>
                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                            </div>
                            <div class="modal-body">
                                <div class="form-group">
                                    <input class="layui-input" type="email" name="testTo" placeholder="输入接收邮箱">
                                </div>
                            </div>
                            <div class="modal-footer">
                                <div id="testMailMsg"></div>
                                <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">关闭</button>
                                <button type="button" class="btn btn-success btn-sm" id="testSendBtn">发送</button>
                            </div>
                        </div>
                    </div>
                </div>

                <input name="token" id="token" value="<?= LoginAuth::genToken() ?>" type="hidden"/>
                <div class="layui-form-item">
                    <div class="layui-input-block">
                        <button type="submit" class="layui-btn" lay-submit lay-filter="demo1">保存设置</button>
                        <input type="button" value="发送测试" class="layui-btn layui-bg-blue" data-toggle="modal" data-target="#testMail"/>
                        <button type="reset" class="layui-btn layui-btn-primary">重置</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>





<script>


    $(function () {
        // menu
        $("#menu-system").attr('class', 'admin-menu-item has-list in');
        $("#menu-system .fa-angle-right").attr('class', 'admin-arrow fa fa-angle-right active');
        $("#menu-system > .submenu").css('display', 'block');
        $('#menu-setting > a').attr('class', 'menu-link active')

        // 提交表单
        $("#setting_form").submit(function (event) {
            event.preventDefault();
            submitForm("#setting_form");
        });

        // test sendmail
        $("#testSendBtn").click(function () {
            $("#testMailMsg").html("<small class='text-secondary'>发送中...<small>");
            $.post("setting.php?action=mail_test", $("#setting_form").serialize(), function (data) {
                if (data === '') {
                    $("#testMailMsg").html("<small class='text-success'>发送成功</small>");
                } else {
                    $("#testMailMsg").html(data);
                }

            });
        })
    });
</script>
