<?php
/**
 * 首页模板
 */
defined('EM_ROOT') || exit('access denied!');

$shopController = new Shop_Controller();

$category = $shopController->getAllCategory();

$sortid = empty($sortid) ? 0 : $sortid;

$goods_list = $shopController->getAllGoods($sortid);

?>
<?php doAction('goods_list'); ?>
<style>
    /* 响应式网格布局 - 基于类名控制 */
    [class*="grid-cols-"] {
        display: grid;
        grid-gap: 0rem;
        padding: 0rem;
    }

    /* 自定义间距系统 */
    .grid-gap-0 { grid-gap: 0; }
    .grid-gap-4 { grid-gap: 0.25rem; } /* 4px */
    .grid-gap-5 { grid-gap: 0.32rem; } /* 5px */
    .grid-gap-10 { grid-gap: 0.625rem; }  /* 10px */
    .grid-gap-12 { grid-gap: 0.75rem; }    /* 12px */
    .grid-gap-15 { grid-gap: 0.938rem; }  /* 15px */

    /* 超小屏幕 (手机, 小于576px) */
    .grid-cols-xs-1 { grid-template-columns: repeat(1, 1fr); }
    .grid-cols-xs-2 { grid-template-columns: repeat(2, 1fr); }
    .grid-cols-xs-3 { grid-template-columns: repeat(3, 1fr); }

    /* 小屏幕 (平板, 576px 及以上) */
    @media (min-width: 576px) {
        .grid-cols-sm-1 { grid-template-columns: repeat(1, 1fr); }
        .grid-cols-sm-2 { grid-template-columns: repeat(2, 1fr); }
        .grid-cols-sm-3 { grid-template-columns: repeat(3, 1fr); }
        .grid-cols-sm-4 { grid-template-columns: repeat(4, 1fr); }
    }

    /* 中等屏幕 (桌面显示器, 768px 及以上) */
    @media (min-width: 768px) {
        .grid-cols-md-1 { grid-template-columns: repeat(1, 1fr); }
        .grid-cols-md-2 { grid-template-columns: repeat(2, 1fr); }
        .grid-cols-md-3 { grid-template-columns: repeat(3, 1fr); }
        .grid-cols-md-4 { grid-template-columns: repeat(4, 1fr); }
        .grid-cols-md-5 { grid-template-columns: repeat(5, 1fr); }
        .grid-cols-md-6 { grid-template-columns: repeat(6, 1fr); }
    }

    /* 大屏幕 (大桌面显示器, 992px 及以上) */
    @media (min-width: 992px) {
        .grid-cols-lg-1 { grid-template-columns: repeat(1, 1fr); }
        .grid-cols-lg-2 { grid-template-columns: repeat(2, 1fr); }
        .grid-cols-lg-3 { grid-template-columns: repeat(3, 1fr); }
        .grid-cols-lg-4 { grid-template-columns: repeat(4, 1fr); }
        .grid-cols-lg-5 { grid-template-columns: repeat(5, 1fr); }
        .grid-cols-lg-6 { grid-template-columns: repeat(6, 1fr); }
    }

    /* 超大屏幕 (超大桌面显示器, 1200px 及以上) */
    @media (min-width: 1200px) {
        .grid-cols-xl-1 { grid-template-columns: repeat(1, 1fr); }
        .grid-cols-xl-2 { grid-template-columns: repeat(2, 1fr); }
        .grid-cols-xl-3 { grid-template-columns: repeat(3, 1fr); }
        .grid-cols-xl-4 { grid-template-columns: repeat(4, 1fr); }
        .grid-cols-xl-5 { grid-template-columns: repeat(5, 1fr); }
        .grid-cols-xl-6 { grid-template-columns: repeat(6, 1fr); }
        .grid-cols-xl-7 { grid-template-columns: repeat(7, 1fr); }
        .grid-cols-xl-8 { grid-template-columns: repeat(8, 1fr); }
    }

    /* 悬浮时图片放大但不超出 */
    .card:hover .goods-cover {
        transform: scale(1.05); /* 放大5% */
    }

    .category-container {
        background: #ffffff;
        border-radius: 8px;
        box-shadow: 0 2px 12px rgba(0, 0, 0, 0.05);
        overflow-x: auto;
    }

    .category-nav {
        display: flex;
        flex-wrap: wrap;
        padding: 1rem;
        gap: 1rem;
    }

    .category-item {
        position: relative;
        flex: 0 0 calc(16.666% - 1rem); /* 默认一行显示6个 */
        transition: all 0.3s ease;
        text-align: center;
    }

    .category-image {
        width: 100%;
        aspect-ratio: 1/1;
        border-radius: 5%;
        background-color: #f0f2f5;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-bottom: 0.5rem;
        overflow: hidden;
    }

    .category-image img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.3s;
    }

    .category-image img:hover {
        transform: scale(1.05);
    }

    .empty-image {
        color: #94a3b8;
        font-size: 1.5rem;
    }

    .category-item a {
        text-decoration: none;
        color: #334155;
        font-weight: 500;
        display: block;
    }

    /* 响应式布局 */
    @media (max-width: 768px) {
        .category-item {
            flex: 0 0 calc(25% - 1rem); /* 平板端一行显示4个 */
        }
    }

    @media (max-width: 576px) {
        .category-item {
            flex: 0 0 calc(26% - 1rem); /* 手机端一行显示3个 */
        }
        .category-item a{
            font-size: 14px;
        }
    }

    /* 强制PC端单行显示 */
    @media (min-width: 769px) {
        .category-nav {
            flex-wrap: nowrap;
        }
        .category-item {
            flex: 0 0 auto;
            width: 90px; /* 固定宽度，保证一行显示更多分类 */
        }
    }
    .goods-list-notice *{
        margin-bottom: 0px;
    }

    .card-heading {
        padding: 10px 8px 3px !important;
        font-size: 14px;
        flex-grow: 1;
        line-height: 1.3;
        height: 47px;
    }
    .goods-price-num{
        font-size: 18px;
        margin-left: 3px;
    }

</style>

    <main class="container blog-container" style="margin-top: 85px;">


        <?php doAction('index_sorts_top'); ?>

        <?php if(!empty($is_index) && !empty(Option::get('home_bulletin'))): ?>
            <div class="goods-list-notice category-container mb-3" style="padding: 0.5rem 1rem 0.5rem 1rem;">
                <?= Option::get('home_bulletin') ?>
            </div>
        <?php endif; ?>

        <?php if(!empty($category) && _g('category_show') == '1'): ?>
        <div class="category-container mb-3">
            <nav class="category-nav">
                <!-- 商品分类项 -->
                <?php foreach($category as $val): ?>
                <div class="category-item">
                    <a href="<?= Url::sort($val['sid']) ?>">
                        <div class="category-image">
                            <img src="<?= $val['sortimg'] ?>" alt="<?= $val['sortname'] ?>">
                        </div>
                        <span><?= $val['sortname'] ?></span>
                    </a>
                </div>
                <?php endforeach; ?>
            </nav>
        </div>
        <?php endif; ?>


        <div class="">

            <?php
                doAction('index_goodslist_top');
                if (!empty($goods_list)):

            ?>
                <div class="grid-cols-lg-6 grid-cols-md-5 grid-cols-sm-3 grid-cols-xs-2 grid-gap-12 ">
                    <?php
                        foreach ($goods_list as $key => $val):
                    ?>
                    <div class="goods-item">
                        <a class="card" href="<?= $val['url'] ?>">
                            <div class="goods-img-container">
                                <img class="goods-cover" src="<?= $val['cover'] ?>" alt="">
                            </div>

                            <div class="card-heading row-2-hidden">
                                <strong class=" " style="word-break: break-all;"><?= $val['title'] ?></strong>
                            </div>
<!--                            <div class="card-content">-->
<!--                                <small class="text-danger">推荐</small>-->
<!--                            </div>-->
                            <div class="card-actions">
                                <div class="pull-left goods-list-price mt-1" style="">
                                    <span class="text-danger currency">&yen;</span><span class="text-danger goods-price-num"><?= $val['price'] ?></span>
                                    <?php if(!empty($val['market_price'])): ?>
                                        <s class="market-price"><span class="currency">&yen;</span><span class="goods-price-num"><?= $val['market_price'] ?></span></s>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </a>
                    </div>
                    <?php endforeach; ?>
                </div>


            <?php

                else:
            ?>
                    <div class="container mt-5 pt-5">
                        <div class="row justify-content-center">
                            <div class="col-md-8 col-lg-6 text-center">
                                <i class="fas fa-shopping-bag fa-4x text-primary mb-3 animated bounce"></i>
                                <h1 class="display-4 font-weight-bold text-muted mb-4">抱歉，未找到商品</h1>
                                <p class="lead text-gray-500 mb-5">
                                    我们暂时没有符合条件的商品，试试以下操作：<br>
                                    <span class="text-primary font-weight-medium">• 检查搜索关键词是否正确</span><br>
                                    <span class="text-primary font-weight-medium">• 浏览热门分类或最新商品</span>
                                </p>
                                <a href="/" class="btn btn-primary btn-lg btn-rounded px-5 mt-3">
                                    返回首页 <i class="fas fa-home ml-2"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                <style>
                    /* 自定义动画 */
                    .animated {
                        animation-duration: 1s;
                        animation-fill-mode: both;
                    }

                    .bounce {
                        animation-name: bounce;
                        animation-iteration-count: infinite;
                    }

                    @keyframes bounce {
                        0%, 100% { transform: translateY(0); }
                        50% { transform: translateY(-15px); }
                    }

                    /* 颜色和排版优化 */
                    .text-gray-500 {
                        color: #6c757d !important;
                    }

                    .btn-rounded {
                        border-radius: 30px;
                    }

                    /* 响应式调整 */
                    @media (max-width: 768px) {
                        .display-4 {
                            font-size: 2.5rem;
                        }
                    }
                </style>
            <?php endif ?>

            <div class="pagination bottom-5">

            </div>
            <?php //include View::getView('side') ?>
        </div>
    </main>
