<?php defined('EM_ROOT') || exit('access denied!'); ?>
<style>
    body {
        background: #f8f9fa;
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 20px;
    }
    .card {
        border-radius: 15px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        border: none;
        transition: all 0.3s ease;
    }
    .card:hover {
        box-shadow: 0 15px 35px rgba(0,0,0,0.15);
    }
    .card-header {
        background: linear-gradient(135deg, #3B82F6, #2563EB);
        color: white;
        border-radius: 15px 15px 0 0 !important;
        padding: 20px;
        text-align: center;
        font-size: 24px;
        font-weight: 600;
    }
    .form-control {
        border-radius: 8px;
        padding: 12px 15px;
        border: 1px solid #e2e8f0;
        transition: border-color 0.2s, box-shadow 0.2s;
    }
    .form-control:focus {
        border-color: #3B82F6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.3);
        outline: none;
    }
    .btn-primary {
        background: linear-gradient(135deg, #3B82F6, #2563EB);
        border: none;
        border-radius: 8px;
        padding: 12px;
        font-size: 18px;
        font-weight: 500;
        transition: all 0.3s ease;
    }
    .btn-primary:hover {
        background: linear-gradient(135deg, #2563EB, #1D4ED8);
        transform: translateY(-2px);
    }
    .btn-primary:active {
        transform: translateY(0);
    }
    .alert {
        border-radius: 8px;
        padding: 12px 15px;
        margin-bottom: 20px;
    }
    .custom-control-label {
        cursor: pointer;
    }
    .login-options {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-top: 15px;
    }
    .login-options a {
        color: #64748B;
        transition: color 0.2s;
    }
    .login-options a:hover {
        color: #3B82F6;
    }
    .login-links {
        display: flex;
        justify-content: center;
        gap: 20px;
        margin-top: 20px;
    }
    .login-links a {
        color: #64748B;
        text-decoration: none;
        transition: color 0.2s;
    }
    .login-links a:hover {
        color: #3B82F6;
        text-decoration: underline;
    }
    .checkcode-container {
        display: flex;
        align-items: center;
        gap: 10px;
    }
    #checkcode {
        border-radius: 8px;
        cursor: pointer;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        transition: transform 0.2s;
    }
    #checkcode:hover {
        transform: scale(1.02);
    }
</style>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-xl-5 col-lg-6 col-md-8 col-sm-8 col-12">
            <div class="card">
                <div class="card-header">
                    <i class="fa fa-sign-in mr-2"></i>用户登录
                </div>
                <div class="card-body p-5">
                    <!-- 提示信息 -->
                    <?php if (isset($_GET['succ_reg'])): ?>
                        <div class="alert alert-success alert-dismissible fade show">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            <i class="fa fa-check-circle mr-2"></i>注册成功，请登录
                        </div>
                    <?php endif ?>

                    <?php if (isset($_GET['succ_reset'])): ?>
                        <div class="alert alert-success alert-dismissible fade show">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            <i class="fa fa-check-circle mr-2"></i>密码重置成功，请登录
                        </div>
                    <?php endif ?>

                    <?php if (isset($_GET['err_ckcode'])): ?>
                        <div class="alert alert-danger alert-dismissible fade show">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            <i class="fa fa-exclamation-circle mr-2"></i>验证错误，请重新输入
                        </div>
                    <?php endif ?>

                    <?php if (isset($_GET['err_login'])): ?>
                        <div class="alert alert-danger alert-dismissible fade show">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            <i class="fa fa-exclamation-circle mr-2"></i>用户或密码错误，请重新输入
                        </div>
                    <?php endif ?>

                    <form method="post" class="user" action="./account.php?action=dosignin&s=<?= $admin_path_code ?>">
                        <div class="form-group">
                            <label for="user" class="sr-only">用户名/邮箱</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><i class="fa fa-user fa-fw"></i></span>
                                </div>
                                <input type="text" class="form-control" id="user" name="user" placeholder="用户名/邮箱" autofocus required>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="pw" class="sr-only">密码</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><i class="fa fa-lock fa-fw"></i></span>
                                </div>
                                <input type="password" class="form-control" id="pw" name="pw" placeholder="密码" required>
                            </div>
                        </div>

                        <?php if ($login_code): ?>
                            <div class="form-group">
                                <label for="login_code" class="sr-only">验证码</label>
                                <div class="checkcode-container">
                                    <div class="input-group flex-grow-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><i class="fa fa-shield"></i></span>
                                        </div>
                                        <input type="text" name="login_code" class="form-control" id="login_code" placeholder="验证码" required>
                                    </div>
                                    <img src="../include/lib/checkcode.php" id="checkcode" onclick="this.src='../include/lib/checkcode.php?'+Math.random()">
                                </div>
                            </div>
                        <?php endif ?>

                        <div class="form-group">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="persist" name="persist" value="1">
                                <label class="custom-control-label" for="persist">记住登录状态</label>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-primary btn-block">
                            <i class="fa iconfont icon-denglu mr-2"></i>登录系统
                        </button>

                        <hr class="my-4">

                        <div class="text-center mt-4">
                            <a href="./account.php?action=signup" class="text-primary">
                                <i class="fa iconfont icon-zhuceyaoqing mr-1"></i>注册新账号
                            </a>
                        </div>

                        <div class="text-center mt-4">
                            <?php doAction('login_ext') ?>
                        </div>

                        <hr class="my-4">

                        <div class="login-links">
                            <a href="../" class="text-muted">
                                <i class="fa fa-home mr-1"></i>返回首页
                            </a>
                            <a href="./account.php?action=reset" class="text-muted">
                                <i class="fa fa-key mr-1"></i>找回密码
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
<script>
    $(function () {
        setTimeout(hideActived, 6000);
        $('#checkcode').click(function () {
            var timestamp = new Date().getTime();
            $(this).attr("src", "../include/lib/checkcode.php?" + timestamp);
        });
    });
</script>
