<?php defined('EM_ROOT') || exit('access denied!'); ?>
<style>
    .layui-elem-quote {
        margin-bottom: 10px;
        padding: 0px 12px;
        line-height: 1.8;
        border-left: 5px solid #16b777;
        border-radius: 0 2px 2px 0;
         background-color: unset;
        margin-top: 15px;
    }
</style>


    <div style="padding: 20px;" id="open-box">

        <div class="media flex content-center">
            <img src="./views/images/order-ico.png" class="align-self-center mr-3" style="width: 56px; float: left;">
            <div class="media-body" style="float: left; margin-left: 20px;">
                <h5 class="mt-0">商品订单</h5>
                <p>订单号：<span class="detail-out_trade_no"><?= $order['out_trade_no'] ?></span></p>
            </div>
        </div>
        <div style="clear: both;"></div>
        <div class="mt-3" style="margin-top: 15px;">
            <div class="grid-cols-lg-4 grid-cols-md-4 grid-cols-sm-4">
                <div class="">
                    <p class="form-text text-muted">订单状态</p>
                    <p id="detail-status"><?= $order['status'] ?></p>
                </div>
                <div class="">
                    <p class="form-text text-muted">订单金额</p>
                    <p id="detail-amount"><?= $order['amount'] ?></p>
                </div>
                <div class="">
                    <p class="form-text text-muted">支付方式</p>
                    <p id="detail-pay_name"><?= $order['payment'] ?></p>
                </div>
                <div class="">
                    <p class="form-text text-muted">下单IP</p>
                    <p id="detail-client_ip"><?= $order['client_ip'] ?></p>
                </div>
            </div>
        </div>
        <blockquote class="layui-elem-quote">用户信息</blockquote>
        <div class="mt-2">
            <div class="grid-cols-sm-2">
                <div style="">
                    <p class="form-text text-muted">用户昵称：<span id="detail-user_nickname"><?= $user['nickname'] ?></span></p>
                </div>
                <div style="">
                    <p class="form-text text-muted">用户账号：<span id="detail-user_email"><?= $user['email'] ?></span></p>
                </div>
            </div>
        </div>
        <blockquote class="layui-elem-quote">商品信息</blockquote>
        <div class="mt-2">
            <div class="grid-cols-sm-2">
                <div style="">
                    <p class="form-text text-muted">标题：<span class="row-1-hidden"><?= $goods['title'] ?></span></p>
                </div>
                <div style="">
                    <p class="form-text text-muted">规格：<span id="detail-attr_spec"><?= $order_list['attr_spec'] ?></span></p>
                </div>
                <div style="">
                    <p class="form-text text-muted">单价：<span id="detail-unit_price"><?= $order_list['unit_price'] ?></span></p>
                </div>
                <div style="">
                    <p class="form-text text-muted">数量：<span id="detail-quantity"><?= $order_list['quantity'] ?></span></p>
                </div>
            </div>
        </div>
        <blockquote class="layui-elem-quote">订单信息</blockquote>
        <div class="mt-2">
            <div class="grid-cols-sm-2">
                <div style="">
                    <p class="form-text text-muted">订单编号：<span class="detail-out_trade_no"><?= $order['out_trade_no'] ?></span></p>
                </div>
                <div style="">
                    <p class="form-text text-muted">商户订单：<span id="detail-up_no"></span><?= $order['up_no'] ?></p>
                </div>
                <div style="">
                    <p class="form-text text-muted">下单时间：<span id="detail-create_time"><?= date('Y-m-d H:i:s', $order['create_time']) ?></span></p>
                </div>
                <div style="">
                    <p class="form-text text-muted">支付时间：<?= empty($order['pay_time']) ? '未支付' : date('Y-m-d H:i:s', $order['pay_time']) ?><span id="detail-pay_time"></span></p>
                </div>
            </div>
        </div>
        <blockquote class="layui-elem-quote">附加选项</blockquote>
        <div class="mt-2">
            <div class="">
                <div style="">
                    <p class="form-text text-muted" id="detail-attach_user"><?= $order_list['attach_user'] ?></p>
                </div>
            </div>
        </div>
        <blockquote class="layui-elem-quote">下单必填项</blockquote>
        <div class="mt-2">
            <div class="row" id="order_required" style="padding-left: 15px;"><?= $order_required ?></div>
        </div>

        <blockquote class="layui-elem-quote">发货信息</blockquote>
        <div class="mt-2">
            <a href="order.php?action=download&order_list_id=<?= $order_list['id'] ?>" target="_blank" style="color: #16baaa;">此处最多显示5条卡密，您可以点击该链接下载全部卡密</a>
            <div class="row">
                <div class="col-sm-12 col-lg-12" style="">
                    <p class="form-text text-muted"><span id="detail-deliver"><?= $order_deliver ?></span></p>
                </div>
            </div>
        </div>
    </div>



<script>
    layui.use(['table'], function(){
        var $ = layui.$;
        var form = layui.form;
        form.on('submit(submit)', function(data){
            var field = data.field; // 获取表单全部字段值
            var url = $('#form').attr('action');
            $.ajax({
                type: "POST",
                url: url,
                data: field,
                dataType: "json",
                success: function (e) {
                    parent.layer.close('detail')
                    parent.layer.msg('操作成功');
                    window.parent.table.reload();
                },
                error: function (xhr) {
                    layer.msg(JSON.parse(xhr.responseText).msg);
                }
            });
            return false; // 阻止默认 form 跳转
        });
    })



    var maxHeight = $(window.parent).innerHeight() * 0.75;
    $("#open-box").css({
        "max-height": maxHeight + "px", // 单位必须加 px
        "overflow-y": "auto" // 内容超过 max-height 时显示垂直滚动条
    });
</script>
