<?php defined('EM_ROOT') || exit('access denied!'); ?>
<style>
    *{
        margin: 0;
    }
    body {
        background-color: #f8f9fa;
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .login-card {
        border-radius: 1rem;
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.05);
        overflow: hidden;
        transition: all 0.3s ease;
    }

    .login-card:hover {
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    }

    .login-header {
        background: linear-gradient(135deg, #165DFF 0%, #4080FF 100%);
        color: white;
        padding: 2rem;
    }

    .login-body {
        padding: 1rem 2rem;
    }

    .login-footer {
        background-color: #f8f9fa;
        border-top: 1px solid #e9ecef;
        padding: 1rem 2rem;
    }

    .form-control {
        border-radius: 0.5rem;
        padding: 0.75rem 1rem;
        border-color: #e9ecef;
    }

    .form-control:focus {
        border-color: #165DFF;
        box-shadow: 0 0 0 0.2rem rgba(22, 93, 255, 0.25);
    }

    .btn-primary {
        background-color: #165DFF;
        border-color: #165DFF;
        padding: 0.75rem;
        border-radius: 0.5rem;
        font-weight: 500;
        transition: all 0.3s ease;
    }

    .btn-primary:hover {
        background-color: #0047CC;
        border-color: #0047CC;
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(22, 93, 255, 0.25);
    }

    .btn-primary:focus {
        box-shadow: 0 0 0 0.2rem rgba(22, 93, 255, 0.25);
    }

    .alert {
        opacity: 1;
        transition: opacity 1s ease-out;
    }

    .fade-out {
        opacity: 0;
    }

    .login-icon {
        width: 3rem;
        height: 3rem;
        background-color: rgba(255, 255, 255, 0.2);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.5rem;
    }

    .input-group-text {
        background-color: white;
        border-right: 0;
        border-radius: 0.5rem 0 0 0.5rem;
    }

    .custom-checkbox .custom-control-input:checked~.custom-control-label::before {
        background-color: #165DFF;
        border-color: #165DFF;
    }

    .custom-control-label::before {
        border-radius: 0.25rem;
    }

    .link-primary {
        color: #165DFF;
    }

    .link-primary:hover {
        color: #0047CC;
    }

    .divider-text {
        position: relative;
        text-align: center;
        margin: 1.5rem 0;
    }

    .divider-text::before,
    .divider-text::after {
        content: "";
        position: absolute;
        top: 50%;
        width: 40%;
        height: 1px;
        background-color: #e9ecef;
    }

    .divider-text::before {
        left: 0;
    }

    .divider-text::after {
        right: 0;
    }

    .captcha-img {
        cursor: pointer;
        border-radius: 0.5rem;
        transition: all 0.3s ease;
    }

    .captcha-img:hover {
        transform: scale(1.02);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
    }

    .captcha-refresh {
        animation: spin 0.5s linear;
    }

    @keyframes spin {
        from { transform: rotate(0deg); }
        to { transform: rotate(360deg); }
    }

    .bg-decoration {
        position: fixed;
        inset: 0;
        overflow: hidden;
        z-index: -1;
    }

    .bg-circle {
        position: absolute;
        width: 300px;
        height: 300px;
        border-radius: 50%;
        filter: blur(50px);
        opacity: 0.1;
    }

    .bg-circle-1 {
        background-color: #165DFF;
        top: -100px;
        right: -100px;
    }

    .bg-circle-2 {
        background-color: #4080FF;
        bottom: -100px;
        left: -100px;
    }
</style>
<!-- 背景装饰 -->
<div class="bg-decoration">
    <div class="bg-circle bg-circle-1"></div>
    <div class="bg-circle bg-circle-2"></div>
</div>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-4 col-md-6 col-sm-8">
            <!-- 登录卡片 -->
            <div class="card login-card">
                <!-- 头部 -->
                <div class="login-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h3 class="font-weight-bold">
                            <i class="fa fa-sign-in mr-2"></i>登录
                        </h3>
                        <div class="login-icon">
                            <i class="fa fa-user-o"></i>
                        </div>
                    </div>
                </div>

                <!-- 主体 -->
                <div class="card-body login-body">
                    <!-- 提示信息 -->
                    <?php if (isset($_GET['succ_reg'])): ?>
                        <div class="alert alert-success">注册成功，请登录</div><?php endif ?>
                    <?php if (isset($_GET['succ_reset'])): ?>
                        <div class="alert alert-success">密码重置成功，请登录</div><?php endif ?>
                    <?php if (isset($_GET['err_ckcode'])): ?>
                        <div class="alert alert-danger">验证错误，请重新输入</div><?php endif ?>
                    <?php if (isset($_GET['err_login'])): ?>
                        <div class="alert alert-danger">用户或密码错误，请重新输入</div><?php endif ?>

                    <form method="post" class="mt-4" action="./account.php?action=dosignin&s=<?= $admin_path_code ?>">
                        <!-- 用户名/邮箱 -->
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fa fa-user"></i>
                                        </span>
                                </div>
                                <input type="text" class="form-control" id="user" name="user" aria-describedby="emailHelp" placeholder="账号" autofocus>
                            </div>
                        </div>

                        <!-- 密码 -->
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fa fa-lock"></i>
                                        </span>
                                </div>
                                <input type="password" class="form-control" id="pw" name="pw" placeholder="密码">
                            </div>
                        </div>

                        <!-- 验证码 -->
                        <?php if ($login_code): ?>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-7 pr-0">
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                    <span class="input-group-text">
                                                        <i class="fa fa-shield text-gray-400"></i>
                                                    </span>
                                            </div>
                                            <input type="text" name="login_code" class="form-control" id="login_code" placeholder="验证码" required>
                                        </div>
                                    </div>
                                    <div class="col-md-5 pl-0">
                                        <img src="../include/lib/checkcode.php" id="checkcode" class="captcha-img w-100 h-100 border">
                                    </div>
                                </div>
                            </div>
                        <?php endif ?>

                        <!-- 记住我 -->
                        <div class="form-group form-check ml-0 pl-0">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="persist" name="persist" value="1">
                                <label class="custom-control-label" for="persist">记住我</label>
                            </div>
                        </div>

                        <!-- 登录按钮 -->
                        <button type="submit" class="btn btn-primary btn-block">
                            <i class="fa fa-sign-in mr-2"></i>登录
                        </button>

<!--                        <div class="divider-text">-->
<!--                            <span class="px-2 bg-white text-muted small">其他选项</span>-->
<!--                        </div>-->

                        <?php if ($is_signup): ?>
<!--                            <div class="text-center">-->
<!--                                <span class="text-muted small">还没有账号?</span>-->
<!--                                <a href="./account.php?action=signup" class="link-primary small font-weight-medium">立即注册</a>-->
<!--                            </div>-->
                        <?php endif ?>

                        <!-- 扩展区域 -->
                        <div class="text-center mt-3">
                            <?php doAction('login_ext') ?>
                        </div>
                    </form>
                </div>

                <!-- 底部 -->
                <div class="login-footer">
                    <div class="d-flex justify-content-between">
                        <a href="../" class="text-muted small">
                            <i class="fa fa-arrow-left mr-1"></i>返回首页
                        </a>
                        <span class="text-muted small">© <?= date('Y') ?> <?= Option::get('blogname') ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
<script>
    $(function () {
        setTimeout(hideActived, 6000);
        $('#checkcode').click(function () {
            var timestamp = new Date().getTime();
            $(this).attr("src", "../include/lib/checkcode.php?" + timestamp);
        });
    });
</script>
