<?php defined('EM_ROOT') || exit('access denied!'); ?>

<style>
    body {
        background-color: #f8f9fa;
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 20px;
    }

    .signup-card {
        border-radius: 1rem;
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.05);
        overflow: hidden;
        transition: all 0.3s ease;
    }

    .signup-card:hover {
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    }

    .signup-header {
        background: linear-gradient(135deg, #00B42A 0%, #00871E 100%);
        color: white;
        padding: 2rem;
    }

    .signup-body {
        padding: 2rem;
    }

    .signup-footer {
        background-color: #f8f9fa;
        border-top: 1px solid #e9ecef;
        padding: 1rem 2rem;
    }

    .form-control {
        border-radius: 0.5rem;
        padding: 0.75rem 1rem;
        border-color: #e9ecef;
    }

    .form-control:focus {
        border-color: #00B42A;
        box-shadow: 0 0 0 0.2rem rgba(0, 180, 42, 0.25);
    }

    .btn-success {
        background-color: #00B42A;
        border-color: #00B42A;
        padding: 0.75rem;
        border-radius: 0.5rem;
        font-weight: 500;
        transition: all 0.3s ease;
    }

    .btn-success:hover {
        background-color: #00871E;
        border-color: #00871E;
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(0, 180, 42, 0.25);
    }

    .btn-success:focus {
        box-shadow: 0 0 0 0.2rem rgba(0, 180, 42, 0.25);
    }

    .btn-outline-success {
        border-color: #00B42A;
        color: #00B42A;
        padding: 0.75rem;
        border-radius: 0.5rem;
        font-weight: 500;
        transition: all 0.3s ease;
    }

    .btn-outline-success:hover {
        background-color: #00B42A;
        border-color: #00B42A;
        color: white;
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(0, 180, 42, 0.25);
    }

    .btn-outline-success:focus {
        box-shadow: 0 0 0 0.2rem rgba(0, 180, 42, 0.25);
    }

    .alert {
        opacity: 1;
        transition: opacity 1s ease-out;
    }

    .fade-out {
        opacity: 0;
    }

    .signup-icon {
        width: 3rem;
        height: 3rem;
        background-color: rgba(255, 255, 255, 0.2);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.5rem;
    }

    .input-group-text {
        background-color: white;
        border-right: 0;
        border-radius: 0.5rem 0 0 0.5rem;
    }

    .link-success {
        color: #00B42A;
    }

    .link-success:hover {
        color: #00871E;
    }

    .divider-text {
        position: relative;
        text-align: center;
        margin: 1.5rem 0;
    }

    .divider-text::before,
    .divider-text::after {
        content: "";
        position: absolute;
        top: 50%;
        width: 40%;
        height: 1px;
        background-color: #e9ecef;
    }

    .divider-text::before {
        left: 0;
    }

    .divider-text::after {
        right: 0;
    }

    .captcha-img {
        cursor: pointer;
        border-radius: 0.5rem;
        transition: all 0.3s ease;
    }

    .captcha-img:hover {
        transform: scale(1.02);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
    }

    .captcha-refresh {
        animation: spin 0.5s linear;
    }

    @keyframes spin {
        from { transform: rotate(0deg); }
        to { transform: rotate(360deg); }
    }

    .bg-decoration {
        position: fixed;
        inset: 0;
        overflow: hidden;
        z-index: -1;
    }

    .bg-circle {
        position: absolute;
        width: 300px;
        height: 300px;
        border-radius: 50%;
        filter: blur(50px);
        opacity: 0.1;
    }

    .bg-circle-1 {
        background-color: #00B42A;
        top: -100px;
        right: -100px;
    }

    .bg-circle-2 {
        background-color: #00871E;
        bottom: -100px;
        left: -100px;
    }

    #send-btn.loading {
        position: relative;
        color: transparent !important;
        pointer-events: none;
    }

    #send-btn.loading::after {
        content: "";
        position: absolute;
        width: 16px;
        height: 16px;
        top: 50%;
        left: 50%;
        margin: -8px 0 0 -8px;
        border: 2px solid rgba(255, 255, 255, 0.3);
        border-radius: 50%;
        border-top-color: #fff;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        to { transform: rotate(360deg); }
    }
</style>
<!-- 背景装饰 -->
<div class="bg-decoration">
    <div class="bg-circle bg-circle-1"></div>
    <div class="bg-circle bg-circle-2"></div>
</div>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-xl-6 col-lg-10 col-md-9">
            <!-- 注册卡片 -->
            <div class="card signup-card">
                <!-- 头部 -->
                <div class="signup-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h3 class="font-weight-bold">
                            <i class="fa fa-user-plus mr-2"></i>注册账号
                        </h3>
                        <div class="signup-icon">
                            <i class="fa fa-pencil-square-o"></i>
                        </div>
                    </div>
                </div>

                <!-- 主体 -->
                <div class="card-body signup-body">
                    <!-- 提示信息 -->
                    <div class="alert alert-danger" style="display: none;" id="send-btn-resp"></div>
                    <?php if (isset($_GET['err_ckcode'])): ?>
                        <div class="alert alert-danger">图形验证错误</div><?php endif ?>
                    <?php if (isset($_GET['err_mail_code'])): ?>
                        <div class="alert alert-danger">邮件验证码错误</div><?php endif ?>
                    <?php if (isset($_GET['error_login'])): ?>
                        <div class="alert alert-danger">错误的邮箱格式</div><?php endif ?>
                    <?php if (isset($_GET['error_exist'])): ?>
                        <div class="alert alert-danger">该邮箱已被注册</div><?php endif ?>
                    <?php if (isset($_GET['error_pwd_len'])): ?>
                        <div class="alert alert-danger">密码不小于6位</div><?php endif ?>
                    <?php if (isset($_GET['error_pwd2'])): ?>
                        <div class="alert alert-danger">两次输入的密码不一致</div><?php endif ?>

                    <form method="post" class="mt-4" action="./account.php?action=dosignup">
                        <!-- 邮箱 -->
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fa fa-envelope text-gray-400"></i>
                                        </span>
                                </div>
                                <input type="email" class="form-control" id="mail" name="mail" aria-describedby="emailHelp" placeholder="邮箱" required autofocus>
                            </div>
                        </div>

                        <!-- 密码 -->
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fa fa-lock text-gray-400"></i>
                                        </span>
                                </div>
                                <input type="password" class="form-control" minlength="6" id="passwd" autocomplete="new-password" name="passwd" placeholder="密码" required>
                            </div>
                        </div>

                        <!-- 确认密码 -->
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fa fa-lock text-gray-400"></i>
                                        </span>
                                </div>
                                <input type="password" class="form-control" minlength="6" id="repasswd" name="repasswd" placeholder="再次输入密码" required>
                            </div>
                        </div>

                        <!-- 邮件验证码 -->
                        <?php if ($email_code): ?>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-7 pr-0">
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                    <span class="input-group-text">
                                                        <i class="fa fa-envelope-o text-gray-400"></i>
                                                    </span>
                                            </div>
                                            <input type="text" name="mail_code" class="form-control" id="mail_code" placeholder="邮件验证码" required>
                                        </div>
                                    </div>
                                    <div class="col-md-5 pl-0">
                                        <button class="btn btn-outline-success btn-block" type="button" id="send-btn">
                                            发送邮件验证码
                                        </button>
                                    </div>
                                </div>
                            </div>
                        <?php endif ?>

                        <!-- 图形验证码 -->
                        <?php if ($login_code): ?>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-7 pr-0">
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                    <span class="input-group-text">
                                                        <i class="fa fa-shield text-gray-400"></i>
                                                    </span>
                                            </div>
                                            <input type="text" name="login_code" class="form-control" id="login_code" placeholder="验证码" required>
                                        </div>
                                    </div>
                                    <div class="col-md-5 pl-0">
                                        <img src="../include/lib/checkcode.php" id="checkcode" class="captcha-img w-100 h-100 border">
                                    </div>
                                </div>
                            </div>
                        <?php endif ?>

                        <!-- 注册按钮 -->
                        <button type="submit" class="btn btn-success btn-block">
                            <i class="fa fa-check mr-2"></i>注册
                        </button>

                        <!-- 分隔线 -->
                        <div class="divider-text">
                            <span class="px-2 bg-white text-muted small">已有账号?</span>
                        </div>

                        <!-- 登录链接 -->
                        <div class="text-center">
                            <a href="./" class="link-success small font-weight-medium">立即登录</a>
                        </div>

                        <!-- 扩展区域 -->
                        <div class="text-center mt-3">
                            <?php doAction('signup_ext') ?>
                        </div>

                        <!-- 返回首页 -->
                        <div class="divider-text">
                            <span class="px-2 bg-white text-muted small">其他选项</span>
                        </div>
                        <div class="text-center">
                            <a href="../" class="text-muted small">
                                <i class="fa fa-arrow-left mr-1"></i>返回首页
                            </a>
                        </div>
                    </form>
                </div>

                <!-- 底部 -->
                <div class="signup-footer">
                    <div class="text-center text-muted small">
                        © 2025 系统名称
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
</body>
</html>
<script>
    // send mail code
    $(function () {
        setTimeout(hideActived, 6000);
        $('#checkcode').click(function () {
            var timestamp = new Date().getTime();
            $(this).attr("src", "../include/lib/checkcode.php?" + timestamp);
        });

        $('#send-btn').click(function () {
            const email = $('#mail').val();
            const sendBtn = $(this);
            const sendBtnResp = $('#send-btn-resp');
            sendBtnResp.html('')
            sendBtn.prop('disabled', true);
            $.ajax({
                type: 'POST',
                url: './account.php?action=send_email_code',
                data: {
                    mail: email
                },
                success: function (response) {
                    // 发送邮件成功后，启动倒计时
                    let seconds = 60;
                    // 启动倒计时
                    const countdownInterval = setInterval(() => {
                        seconds--;
                        if (seconds <= 0) {
                            clearInterval(countdownInterval);
                            sendBtn.html('发送邮件验证码');
                            sendBtn.prop('disabled', false);
                        } else {
                            sendBtn.html('已发送,请查收邮件 ' + seconds + '秒');
                        }
                    }, 1000);
                },
                error: function (data) {
                    sendBtnResp.html(data.responseJSON.msg).addClass('text-danger').show()
                    sendBtn.prop('disabled', false);
                }
            });
        });
    });
</script>
