<?php
defined('EM_ROOT') || exit('access denied!');

$order_required = getOrderRequired();

$rq = '';
foreach($order_required as $key => $val){
    $rq .= '/' . $val['name'];
}

?>
<style>
    .panel-body .comment:last-child{
        border-bottom: unset;
    }

    .card-hover:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        transition: all 0.3s ease;
    }
    .tab-content {
        min-height: 400px;
    }
    .order-item {
        border-left: 3px solid transparent;
    }
    .order-item:hover {
        /*background-color: #e2efff;*/
    }

    .order-item:nth-child(odd) {
        border-left-color: #cee6ff;
    }

    .order-item:nth-child(even) {
        border-left-color: #ffc7cc;
    }


    .fade-in {
        animation: fadeIn 0.5s ease-in-out;
    }
    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(10px); }
        to { opacity: 1; transform: translateY(0); }
    }
    .suborder-list {
        margin-top: 1rem;
        border-top: 1px solid #eee;
        padding-top: 1rem;
    }
    .suborder-item:not(:last-child) {
        margin-bottom: 1rem;
        padding-bottom: 1rem;
        border-bottom: 1px solid #f8f9fa;
    }
    .order-summary {
        background-color: #f8f9fa;
        padding: 1rem;
        margin-top: 1rem;
        border-radius: 4px;
    }
    .goods-title{
        word-break: break-all;
        margin-right: 30px;
    }
</style>


<main class="">
    <!-- 订单类型选项卡 -->
    <div class="col-xl-12">
        <div class="card shadow">
            <div class="card-header bg-white">
                <ul class="nav nav-tabs card-header-tabs" id="orderTabs" role="tablist">
                    <li class="nav-item">
                        <a href="order.php" class="nav-link <?= $tab == 'member' ? 'active' : '' ?>" id="member-tab">
                            <i class="fa fa-user-circle mr-2"></i>我的订单
                        </a>
                    </li>
                    <li class="nav-item ">
                        <a href="order.php?action=search" class="nav-link <?= $tab == 'search' ? 'active' : '' ?>" id="search-tab">
                            <i class="fa fa-search mr-2"></i>游客查单
                        </a>
                    </li>
                </ul>
            </div>

            <div class="card-body">
                <div class="tab-content" id="orderTabsContent">
                    <!-- 会员订单选项卡内容 -->
                    <?php if($action == ''): ?>
                    <div class="tab-pane fade <?= $tab == 'member' ? 'show active' : '' ?>" id="member" role="tabpanel" aria-labelledby="member-tab">
                        <div class="row mb-4">
                            <div class="col-md-6">
<!--                                <h4 class="mb-0">我的订单</h4>-->
<!--                                        <p class="text-muted">查看和管理您的会员订单</p>-->
                            </div>
                            <!--<div class="col-md-6 text-right">
                                <div class="btn-group">
                                    <button class="btn btn-sm btn-outline-secondary">全部</button>
                                    <button class="btn btn-sm btn-outline-secondary">待支付</button>
                                    <button class="btn btn-sm btn-outline-secondary">已完成</button>
                                    <button class="btn btn-sm btn-outline-secondary">已取消</button>
                                </div>
                            </div>-->
                        </div>

                        <!-- 订单列表 -->
                        <div class="list-group">

                            <?php foreach ($order as $key => $val): ?>
                            <div class="list-group-item order-item pending fade-in" style="animation-delay: 0.1s">
                                <div class="d-flex justify-content-between align-items-start">
                                    <div>
                                        <h5 class="mb-1">订单号:  <?= $val['out_trade_no'] ?></h5>
                                        <p class="text-muted mb-1"><?= date('Y-m-d H:i:s', $val['create_time']) ?></p>
                                    </div>
                                    <?php if(empty($val['pay_time'])): ?>
                                    <span class="badge badge-warning px-3 py-1 mt-1">待支付</span>
                                    <?php endif; ?>
                                </div>

                                <!-- 子订单列表 -->
                                <div class="suborder-list">
                                    <?php foreach($val['list'] as $v): ?>
                                    <div class="suborder-item">
                                        <div class="media">
                                            <a href="<?= $v['goods_url'] ?>">
                                                <img style="width: 80px; height: 80px;" src="<?= $v['cover'] ?>" alt="" class="mr-3 rounded">
                                            </a>

                                            <div class="media-body">
                                                <div class="d-flex justify-content-between">
                                                    <div>
                                                        <a href="<?= $v['goods_url'] ?>" class="mt-1" style="display: block;">
                                                            <h6 class="mt-0 goods-title"><?= $v['title'] ?></h6>
                                                        </a>

                                                        <p class="text-muted mb-0"><?= $v['attr_spec'] ?></p>
                                                    </div>
                                                    <div class="text-right">
                                                        <p class="font-weight-bold">¥<?= $v['unit_price'] / 100 ?></p>
                                                        <p class="text-muted">x<?= $v['quantity'] ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; ?>
                                </div>

                                <!-- 订单摘要 -->
                                <div class="order-summary">
                                    <div class="d-flex justify-content-between">
                                        <span>付款时间</span>
                                        <span><?= empty($val['pay_time']) ? '<span class="text-danger">未付款</span>' : date('Y-m-d H:i:s', $val['pay_time']) ?></span>
                                    </div>
                                    <div class="d-flex justify-content-between">
                                        <span>商品总价</span>
                                        <span>¥<?= $val['amount'] ?></span>
                                    </div>
                                    <div class="d-flex justify-content-between font-weight-bold">
                                        <span>实付款</span>
                                        <span>¥<?= $val['amount'] ?></span>
                                    </div>
                                </div>

                                <div class="mt-3 text-right">
                                    <div class="btn-group">
                                        <?php if($v['type'] == 'xuni' || $v['type'] == 'post'): ?>
                                            <?php if(!empty($val['pay_time'])): ?>
                                                <span class="badge <?= $val['service_status'] == 0 ? 'badge-warning' : 'badge-info' ?>">
                                                    <?= $val['service_status'] == 0 ? '服务进行中' : $val['device'] ?>
                                                </span>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <?php if(!empty($val['pay_time'])): ?>
                                                <a href="?action=sdk&out_trade_no=<?= $val['out_trade_no'] ?>&id=<?= $v['id'] ?>" class="btn btn-sm btn-primary">
                                                    <i class="fas fa-key mr-1"></i> 查看卡密
                                                </a>
                                                <a href="<?= $v['goods_url'] ?>" class="btn btn-sm btn-outline-secondary ml-2">再次购买</a>
                                            <?php endif; ?>
                                        <?php endif; ?>

                                        <!-- 付款操作 -->
                                        <?php if(empty($val['pay_time'])): ?>
                                            <form action="/?action=pay" method="post" target="_blank" class="d-flex align-items-center">
                                                <div style="display: none;">
                                                    <input type="text" name="out_trade_no" value="<?= $val['out_trade_no'] ?>">
                                                    <input type="text" name="payment" id="payment-<?= $key ?>" value="" />
                                                    <input type="text" name="pay_plugin" id="pay_plugin-<?= $key ?>" value="" />
                                                    <input type="text" name="pay_name" id="pay_name-<?= $key ?>" value="" />
                                                </div>

                                                <div class="btn-group">
                                                    <button type="button" class="btn btn-sm btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        立即支付 <i class="fas fa-chevron-down ml-1"></i>
                                                    </button>
                                                    <div class="dropdown-menu">
                                                        <?php foreach($mode_payment as $pay): ?>
                                                            <a class="dropdown-item pay-btn" data-key="<?= $key ?>" href="javascript:;" data-pay-plugin="<?= $pay['plugin_name'] ?>" data-pay-name="<?= $pay['name'] ?>">
                                                                <i class="fab fa-<?= strtolower($pay['name']) ?> mr-2"></i> <?= $pay['name'] ?>
                                                            </a>
                                                        <?php endforeach; ?>
                                                    </div>
                                                </div>
                                                <button type="submit" class="btn btn-success ml-2 go-pay-<?= $key ?>" style="display: none;">
                                                    <i class="fas fa-hand-holding-usd mr-1"></i> 立即付款
                                                </button>


                                            </form>
                                        <?php endif; ?>

<!--                                                <button class="btn btn-sm btn-outline-secondary">取消订单</button>-->
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>

                        </div>

                        <!-- 分页 -->
                        <div class="mt-4 text-center">
                            <nav aria-label="Page navigation">

                            </nav>
                        </div>
                    </div>
                    <?php endif; ?>
                    <!-- 在线查单选项卡内容 -->
                    <?php if($action == 'search'): ?>
                    <div class="tab-pane fade <?= $tab == 'search' ? 'show active' : '' ?>"  id="search" role="tabpanel" aria-labelledby="search-tab">

                        <div class="row justify-content-center">
                            <div class="col-md-8">
                                <?php if(empty($type) || empty($pwd)): ?>
                                    <div class="card mb-5">
                                        <div class="card-body text-center p-5">
                                            <h4 class="mb-4">订单查询</h4>
<!--                                            <p class="text-muted mb-4">请输入订单号或查单密码查询订单</p>-->
                                            <form action="?" method="get">
                                                <input type="hidden" name="action" class="form-control" value="search">
                                                <div class="form-group row">
                                                    <div class="col-sm-10 offset-sm-1">
                                                        <div class="input-group">
                                                            <input type="text" name="pwd" class="form-control" placeholder="订单号<?= $rq ?>">

                                                            <div class="input-group-append">
                                                                <button type="submit" class="btn btn-primary">
                                                                    <i class="fa fa-search mr-2"></i>查询
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            </form>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <?php if(isset($orderNum) && $orderNum <= 0 && !empty($type) && !empty($pwd)): ?>

                                    <div class="card text-center p-5" id="noResult">
                                        <div class="card-body">
                                            <div class="mb-4">
                                                <i class="fa fa-search fa-5x text-muted"></i>
                                            </div>
                                            <h5 class="mb-2">未找到匹配的订单</h5>
                                            <p class="text-muted">请检查输入的订单号或查单密码是否正确</p>
                                            <a href="?action=search" class="btn btn-outline-primary mt-3">重新查询</a>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>

                        </div>
                        <!-- 查询结果 (默认隐藏) -->
                        <?php if(isset($orderNum) && $orderNum > 0): ?>
                            <div class="card id="searchResult">
                                <div class="list-group">

                                    <?php foreach ($order as $key => $val): ?>
                                        <div class="list-group-item order-item pending fade-in" style="animation-delay: 0.1s">
                                            <div class="d-flex justify-content-between align-items-start">
                                                <div>
                                                    <h5 class="mb-1">订单号:  <?= $val['out_trade_no'] ?></h5>
                                                    <p class="text-muted mb-1"><?= date('Y-m-d H:i:s', $val['create_time']) ?></p>
                                                </div>
                                                <?php if(empty($val['pay_time'])): ?>
                                                    <span class="badge badge-warning px-3 py-1 mt-1">待支付</span>
                                                <?php endif; ?>
                                            </div>

                                            <!-- 子订单列表 -->
                                            <div class="suborder-list">
                                                <?php foreach($val['list'] as $v): ?>
                                                    <div class="suborder-item">
                                                        <div class="media">
                                                            <a href="<?= $v['goods_url'] ?>">
                                                                <img style="width: 80px; height: 80px;" src="<?= $v['cover'] ?>" alt="" class="mr-3 rounded">
                                                            </a>

                                                            <div class="media-body">
                                                                <div class="d-flex justify-content-between">
                                                                    <div>
                                                                        <a href="<?= $v['goods_url'] ?>" class="mt-1" style="display: block;">
                                                                            <h6 class="mt-0 goods-title"><?= $v['title'] ?></h6>
                                                                        </a>

                                                                        <p class="text-muted mb-0"><?= $v['attr_spec'] ?></p>
                                                                    </div>
                                                                    <div class="text-right">
                                                                        <p class="font-weight-bold">¥<?= $v['unit_price'] / 100 ?></p>
                                                                        <p class="text-muted">x<?= $v['quantity'] ?></p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php endforeach; ?>
                                            </div>

                                            <!-- 订单摘要 -->
                                            <div class="order-summary">
                                                <div class="d-flex justify-content-between">
                                                    <span>付款时间</span>
                                                    <span><?= empty($val['pay_time']) ? '<span class="text-danger">未付款</span>' : date('Y-m-d H:i:s', $val['pay_time']) ?></span>
                                                </div>
                                                <div class="d-flex justify-content-between">
                                                    <span>商品总价</span>
                                                    <span>¥<?= $val['amount'] ?></span>
                                                </div>
                                                <div class="d-flex justify-content-between font-weight-bold">
                                                    <span>实付款</span>
                                                    <span>¥<?= $val['amount'] ?></span>
                                                </div>
                                            </div>

                                            <div class="mt-3 text-right">
                                                <div class="btn-group">
                                                    <?php if($v['type'] == 'xuni'): ?>
                                                        <?php if(!empty($val['pay_time'])): ?>
                                                            <span class="badge <?= $val['service_status'] == 0 ? 'badge-warning' : 'badge-info' ?>">
                                                                            <?= $val['service_status'] == 0 ? '服务进行中' : $val['device'] ?>
                                                                        </span>
                                                        <?php endif; ?>
                                                    <?php else: ?>
                                                        <?php if(!empty($val['pay_time'])): ?>
                                                            <a href="?action=sdk&out_trade_no=<?= $val['out_trade_no'] ?>&id=<?= $v['id'] ?>" class="btn btn-sm btn-primary">
                                                                <i class="fas fa-key mr-1"></i> 查看卡密
                                                            </a>
                                                            <a href="<?= $v['goods_url'] ?>" class="btn btn-sm btn-outline-secondary ml-2">再次购买</a>
                                                        <?php endif; ?>
                                                    <?php endif; ?>

                                                    <!-- 付款操作 -->
                                                    <?php if(empty($val['pay_time'])): ?>
                                                        <form action="/?action=pay" method="post" target="_blank" class="d-flex align-items-center">
                                                            <div style="display: none;">
                                                                <input type="text" name="out_trade_no" value="<?= $val['out_trade_no'] ?>">
                                                                <input type="text" name="payment" id="payment-<?= $key ?>" value="" />
                                                                <input type="text" name="pay_plugin" id="pay_plugin-<?= $key ?>" value="" />
                                                                <input type="text" name="pay_name" id="pay_name-<?= $key ?>" value="" />
                                                            </div>

                                                            <div class="btn-group">
                                                                <button type="button" class="btn btn-sm btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                                    立即支付 <i class="fas fa-chevron-down ml-1"></i>
                                                                </button>
                                                                <div class="dropdown-menu">
                                                                    <?php foreach($mode_payment as $pay): ?>
                                                                        <a class="dropdown-item pay-btn" data-key="<?= $key ?>" href="javascript:;" data-pay-plugin="<?= $pay['plugin_name'] ?>" data-pay-name="<?= $pay['name'] ?>">
                                                                            <i class="fab fa-<?= strtolower($pay['name']) ?> mr-2"></i> <?= $pay['name'] ?>
                                                                        </a>
                                                                    <?php endforeach; ?>
                                                                </div>
                                                            </div>
                                                            <button type="submit" class="btn btn-success ml-2 go-pay-<?= $key ?>" style="display: none;">
                                                                <i class="fas fa-hand-holding-usd mr-1"></i> 立即付款
                                                            </button>


                                                        </form>
                                                    <?php endif; ?>

                                                    <!--                                                <button class="btn btn-sm btn-outline-secondary">取消订单</button>-->
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

</main>
<?php if(!empty($pageurl)): ?>
<div class="page"><?= $pageurl ?> </div>
<?php endif; ?>
<?php if(isset($orderNum)): ?>
<div class="text-center small">(共有 <?= $orderNum ?> 个订单)</div>
<?php endif; ?>

<script>
    $(function () {
        $('.pay-btn').click(function(){
            let key = $(this).data('key');
            let pay_plugin = $(this).data('pay-plugin');
            let pay_name = $(this).data('pay-name');
            $('#pay_plugin-' + key).val(pay_plugin);
            $('#pay_name-' + key).val(pay_name);
            $('#payment-' + key).val(pay_name);
            $('.go-pay-' + key).click();
        })
    });
</script>
