<?php
defined('EM_ROOT') || exit('access denied!');
?>

<div style="padding: 20px 0px;">

    <form class="layui-form" style="float: right;">

        <div class="layui-form-item">

            <div class="layui-inline">

                <div class="layui-input-inline layui-input-wrap">
                    <select name="category_id">
                        <option value="">商品分类</option>
                        <?php foreach($sorts as $val): ?>
                            <option value="<?= $val['sid'] ?>"><?= $val['sortname'] ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="layui-input-inline layui-input-wrap">
                    <input type="text" value="" name="keyword" placeholder="商品名称" lay-affix="clear" class="layui-input">
                </div>
                <div class="layui-form-mid" style="padding: 0!important;">
                    <button class="layui-btn" lay-submit lay-filter="index-search">搜索</button>
                    <button type="reset" class="layui-btn layui-btn-primary">重置</button>
                </div>
            </div>
        </div>

    </form>


    <table class="layui-hide" id="index" lay-filter="index"></table>
</div>
<script type="text/html" id="toolbar">
    <div class="layui-btn-container">
        <button class="layui-btn layui-btn-primary layui-border-green" lay-event="refresh">
            <i class="fa fa-refresh" style=""></i>
        </button>
        <button type="button" class="layui-btn" lay-event="add">添加</button>
        <button id="toolbar-del" class="layui-btn layui-btn-sm layui-bg-red layui-btn-disabled" lay-event="del">
            删除
        </button>
        <button type="button" class="layui-btn layui-bg-blue" lay-event="export_log">导出记录</button>
    </div>
</script>
<script type="text/html" id="cover">
    <div class="layui-clear-space">
        <a href="javascript:;" data-id="{{ d.id }}" lay-event="img">
            <img onerror="this.onerror=null; this.src='./views/images/null.png'" class="cover" data-img="{{ d.cover }}" src="{{ d.cover }}" style="width: 40px; border-radius: 3px;" />
        </a>
    </div>
</script>

<script type="text/html" id="title">
    <div class="layui-clear-space">
        <span>
            {{#  if(d.type == 'duli'){ }}
            <span class="layui-badge layui-bg-green">{{ d.type_text }}</span>
            {{#  }else if(d.type == 'xuni'){ }}
            <span class="layui-badge layui-bg-red">{{ d.type_text }}</span>
            {{#  }else if(d.type == 'guding'){ }}
            <span class="layui-badge layui-bg-blue">{{ d.type_text }}</span>
            {{#  }else if(d.type == 'post'){ }}
            <span class="layui-badge layui-bg-purple">{{ d.type_text }}</span>
            {{#  }else{ }}
            <span class="layui-badge layui-bg-orange">未知类型</span>
            {{#  } }}

        </span>
        {{#  if(d.is_sku == 'y'){ }}
        <span style="margin-left: 8px;" class="layui-badge-rim layui-border-blue">多规格</span>
        {{#  } }}
        {{#  if(d.is_sku == 'n'){ }}
        <span style="margin-left: 8px;" class="layui-badge-rim layui-border-cyan">单规格</span>
        {{#  } }}
        <span style="margin-left: 8px;">{{ d.title }}</span>
    </div>
</script>
<script type="text/html" id="is_sku">
    <div class="layui-clear-space">

    </div>
</script>
<script type="text/html" id="is_on_shelf">
    <input type="checkbox" name="{{= d.id }}" value="{{= d.id }}" title=" ON |OFF " lay-skin="switch" lay-filter="switch" {{= d.is_on_shelf == 1 ? "checked" : "" }}>
</script>
<script type="text/html" id="type">
    <div class="layui-clear-space">
        <span>{{ d.type_text }}</span>
    </div>
</script>
<script type="text/html" id="stock">
    <div class="layui-clear-space">
        {{ d.stock }}
    </div>
</script>
<script type="text/html" id="money">
    <div class="layui-clear-space">
        <a href="javascript:;" style="color: #16baaa;" data-id="{{ d.uid }}" lay-event="money">{{ d.money }}</a>
    </div>
</script>
<script type="text/html" id="operate">
    <div class="layui-clear-space">
        <a class="layui-btn" lay-event="edit">编辑</a>
        <a class="layui-btn layui-bg-blue" lay-event="stock">库存</a>
        <a class="layui-btn layui-bg-red" lay-event="del">删除</a>
    </div>
</script>


<script>
    layui.use(['table'], function(){
        var table = layui.table;
        var form = layui.form;

        // 从本地存储读取每页条数（默认10）
        var pageSize = localStorage.getItem('goods_limit') || 10;
        pageSize = parseInt(pageSize); // 确保是数字类型

        // 创建渲染实例
        window.table = table.render({
            elem: '#index',
            autoSort: false,
            url: '?action=index', // 此处为静态模拟数据，实际使用时需换成真实接口
            toolbar: '#toolbar',
            limits: [10,20,30,50,100],
            page: true,
            limit: pageSize,
            lineStyle: 'height: 30px;',
            defaultToolbar: ['filter', 'exports', 'print', { // 右上角工具图标
                title: '提示',
                layEvent: 'LAYTABLE_TIPS',
                icon: 'layui-icon-tips',
                onClick: function(obj) { // 2.9.12+
                    layer.alert('自定义工具栏图标按钮');
                }
            }],


            cols: [[
                {type: 'checkbox'},
                {field:'name', title:'封面图', width: 80, templet: '#cover', align: 'center'},
                {field:'title', title:'商品标题', minWidth: 170, templet: '#title'},
                {field:'sort_name', title:'商品分类', width: 130, align: 'center', sort: true },
                // {field:'is_sku', title:'规格类型', width: 90, align: 'center', templet: '#is_sku' },
                {field:'sales', title:'销量', width: 100, sort: true, align: 'center'},
                {field:'stock', title:'库存', sort: true, width: 100, templet: '#stock', align: 'center' },
                {field:'is_on_shelf', title:'上架', align: 'center', width: 100, templet: '#is_on_shelf'},
                {field:'create_time', title:'添加时间', sort: true, width: 150, align: 'center'},
                {title:'操作', templet: '#operate', width: 210, align: 'center'}
            ]],

            error: function(res, msg){
                console.log(res, msg)
            },
            done: function(res, curr, count) {
                // 绑定分页下拉框的change事件（注意：需在done回调中绑定，确保元素已渲染）
                var that = this;
                setTimeout(function () {
                    // 找到分页控件中的下拉框（Layui分页的class固定为 layui-laypage-limits）
                    document.querySelector('.layui-laypage-limits select').addEventListener('change', function () {
                        var newSize = this.value; // 获取用户选择的新每页条数
                        // 存储到本地存储
                        localStorage.setItem('goods_limit', newSize);
                        // 重新渲染表格（保持当前页码，应用新的每页条数）
                        table.reload(that.config.id, {
                            page: {
                                curr: curr // 保持当前页码
                            },
                            limit: newSize // 应用新的每页条数
                        });
                    });
                }, 0);
            }
        });



        // 状态 - 开关操作
        form.on('switch(switch)', function(obj){
            var active = obj.elem.checked == true ? 1 : 0;
            var id = this.name;
            var loadSwitch = layer.load(2);
            $.ajax({
                url: '?action=shelf',
                type: 'POST',
                dataType: 'json',
                data: { goods_id: id, status: active, token: '<?= LoginAuth::genToken() ?>' },
                success: function(res) {
                    layer.msg('操作成功');
                },
                error: function(err) {
                    layer.msg(err.responseJSON.msg);
                },
                complete: function() {
                    layer.close(loadSwitch);
                }
            });
        });

        // 搜索提交
        form.on('submit(index-search)', function(data){
            var field = data.field; // 获得表单字段
            // 执行搜索重载
            table.reload('index', {
                page: {
                    curr: 1 // 重新从第 1 页开始
                },
                where: field // 搜索的字段
            });
            return false; // 阻止默认 form 跳转
        });


        // 工具栏事件
        table.on('toolbar(index)', function(obj){
            var id = obj.config.id;
            var checkStatus = table.checkStatus(id);
            var othis = lay(this);
            if(obj.event == 'refresh'){
                table.reload(id);
            }
            if(obj.event == 'add'){
                location.href="goods.php?action=release"
            }
            if(obj.event == 'del'){
                var data = checkStatus.data;
                if(data.length == 0){
                    return;
                }
                var ids = $.map(data, function(item) {
                    return item.id; // 提取每个对象的uid
                }).join(',');
                layer.confirm('确定要删除选中的数据？', {
                    btn: ['确认', '取消'], // 按钮
                    icon: 3,             // 图标，3表示问号
                    title: '温馨提示'
                }, function(index) {
                    layer.close(index); // 关闭对话框
                    $.ajax({
                        url: '?action=del',
                        type: 'POST',
                        dataType: 'json',
                        data: { ids: ids, token: '<?= LoginAuth::genToken() ?>' },
                        success: function(res) {
                            layer.msg('删除成功');
                            table.reload(id);
                        },
                        error: function(err) {
                            layer.msg(err.responseJSON.msg);
                        }
                    });
                });
            }
            if(obj.event === 'export_log'){
                let isMobile = window.innerWidth < 1200;
                let area = isMobile ? ['98%', '85%']  : ['1000px', '800px'];
                layer.open({
                    id: 'export_log',
                    title: '卡密导出记录',
                    type: 2,
                    area: area,
                    // skin: 'layui-layer-win10',
                    skin: 'layui-layer-molv',
                    content: 'stock.php?action=export_log',
                    fixed: false, // 不固定
                    scrollbar: false,
                    maxmin: true,
                    shadeClose: true,
                    success: function(layero, index, that){
                    }
                });
            }

        });

        // 触发单元格工具事件
        table.on('tool(index)', function(obj){ // 双击 toolDouble
            var data = obj.data; // 获得当前行数据
            var id = obj.config.id;
            if(obj.event == 'del'){
                layer.confirm('确定删除？', {
                    btn: ['确认', '取消'], // 按钮
                    icon: 3,             // 图标，3表示问号
                    title: '温馨提示'
                }, function(index) {
                    layer.close(index); // 关闭对话框
                    $.ajax({
                        url: '?action=del',
                        type: 'POST',
                        dataType: 'json',
                        data: { ids: data.id, token: '<?= LoginAuth::genToken() ?>' },
                        success: function(res) {
                            layer.msg('删除成功');
                            table.reload(id);
                        },
                        error: function(err) {
                            layer.msg(err.responseJSON.msg);
                        }
                    });
                });
            }

            if(obj.event === 'img'){
                layer.photos({
                    photos: {
                        "title": data.title,
                        "start": 0,
                        "data": [
                            {
                                "alt": data.title,
                                "pid": 1,
                                "src": data.cover,
                            }
                        ]
                    }
                });
            }
            if(obj.event === 'edit'){
                location.href = "goods.php?action=edit&id=" + data.id;
            }
            if(obj.event === 'stock'){
                let isMobile = window.innerWidth < 1200;
                let area = isMobile ? ['98%', '85%']  : ['1000px', '800px'];
                layer.open({
                    id: 'stock',
                    title: '库存管理',
                    type: 2,
                    area: area,
                    // skin: 'layui-layer-win10',
                    skin: 'layui-layer-molv',
                    content: 'stock.php?action=index_ws&goods_id=' + data.id,
                    fixed: false, // 不固定
                    scrollbar: false,
                    maxmin: true,
                    shadeClose: true,
                    success: function(layero, index, that){
                    }
                });
            }
        });

        // 触发排序事件
        table.on('sort(index)', function(obj){
            console.log(obj.field); // 当前排序的字段名
            console.log(obj.type); // 当前排序类型：desc（降序）、asc（升序）、null（空对象，默认排序）
            console.log(this); // 当前排序的 th 对象

            // 尽管我们的 table 自带排序功能，但并没有请求服务端。
            // 有些时候，你可能需要根据当前排序的字段，重新向后端发送请求，从而实现服务端排序，如：
            table.reload('index', {
                initSort: obj, // 记录初始排序，如果不设的话，将无法标记表头的排序状态。
                where: { // 请求参数（注意：这里面的参数可任意定义，并非下面固定的格式）
                    field: obj.field, // 排序字段
                    order: obj.type // 排序方式
                }
            });
        });

        // 触发表格复选框选择
        table.on('checkbox(index)', function(obj){
            var id = obj.config.id;
            var checkData = table.checkStatus(id).data;
            console.log(checkData)
            if(checkData.length == 0){
                $('#toolbar-del').addClass('layui-btn-disabled');
            }else{
                $('#toolbar-del').removeClass('layui-btn-disabled');
            }
        });

        // 分页栏事件
        table.on('pagebar(index)', function(obj){
            alert()
            console.log(obj); // 查看对象所有成员
            console.log(obj.config); // 当前实例的配置信息
            console.log(obj.event); // 属性 lay-event 对应的值
        });


        // 表头自定义元素工具事件 --- 2.8.8+
        table.on('colTool(test)', function(obj){
            var event = obj.event;
            console.log(obj);
            if(event === 'email-tips'){
                layer.alert(layui.util.escape(JSON.stringify(obj.col)), {
                    title: '当前列属性选项'
                });
            }
        });


    });
</script>



<script>
    $("#menu-goods").attr('class', 'admin-menu-item has-list in');
    $("#menu-goods .fa-angle-right").attr('class', 'admin-arrow fa fa-angle-right active');
    $("#menu-goods > .submenu").css('display', 'block');
    $('#menu-goods-list > a').attr('class', 'menu-link active');
</script>
