// var keys = [['24', '25'], ['12', '13'], ['31', '32']];
// var keys = <?php echo $specification_attr_json ?>;
// var data = {"24;12;31": {price: 366.00, count: 46}, "25;12;32": {price: 406, count: 66}}
// var data = <? echo $product_specification_json; ?>

//保存最后的组合结果信息
var SKUResult = {};
//获得对象的key
function getObjKeys(obj) {
    if (obj !== Object(obj)) throw new TypeError('Invalid object');
    var keys = [];
    for (var key in obj)
        if (Object.prototype.hasOwnProperty.call(obj, key))
            keys[keys.length] = key;
    return keys;
}

//把组合的key放入结果集SKUResult
function add2SKUResult(combArrItem, sku) {
    var key = combArrItem.join("-");
    if(SKUResult[key]) {//SKU信息key属性·
        SKUResult[key].stock = Number(sku.stock) + Number(SKUResult[key].stock);
        SKUResult[key].prices.push(sku.price);
    } else {
        SKUResult[key] = {
            stock : sku.stock,
            prices : [sku.price]
        };
    }
}

//初始化得到结果集
function initSKU() {
    var i, j, skuKeys = getObjKeys(data);
    for(i = 0; i < skuKeys.length; i++) {
        var skuKey = skuKeys[i];//一条SKU信息key
        var sku = data[skuKey];	//一条SKU信息value
        var skuKeyAttrs = skuKey.split("-"); //SKU信息key属性值数组
        skuKeyAttrs.sort(function(value1, value2) {
            return parseInt(value1) - parseInt(value2);
        });
        //对每个SKU信息key属性值进行拆分组合
        var combArr = combInArray(skuKeyAttrs);
        for(j = 0; j < combArr.length; j++) {
            add2SKUResult(combArr[j], sku);
        }
        //结果集接放入SKUResult
        SKUResult[skuKeyAttrs.join("-")] = {
            stock:sku.stock,
            prices:[sku.price]
        }
    }

}

function initPrices() {
    // 1. 选择数据源并统一提取价格
    var prices = [];

    // 优先使用 SKUResult（结构：{spec: {prices: [number]}}）
    if (SKUResult && Object.keys(SKUResult).length > 0) {
        for (const key in SKUResult) {
            if (SKUResult[key]?.prices) {
                SKUResult[key].prices.forEach(p => {
                    const num = parseFloat(p);
                    if (!isNaN(num)) prices.push(num);
                });
            }
        }
    }
    // 回退使用 goods_sku_all_json（结构：{spec: {price: number}}）
    else if (window.goods_sku_all_json && Object.keys(goods_sku_all_json).length > 0) {
        for (const key in goods_sku_all_json) {
            const price = parseFloat(goods_sku_all_json[key]?.price);
            if (!isNaN(price)) prices.push(price);
        }
    }

    // 2. 计算价格区间
    var maxPrice = prices.length ? Math.max(...prices) : 0;
    var minPrice = prices.length ? Math.min(...prices) : 0;

    // 3. 动态显示（保持您的原始逻辑）
    if (prices.length === 0) {
        $('#price').html('0');
    } else if (maxPrice > minPrice) {
        // 未选择完整SKU时显示"30起"
        $('#price').html(minPrice + `<span class="currency" style="margin-left: 3px;">起</span>`);
    } else {
        // 已选择完整SKU时显示"40"
        $('#price').html(maxPrice);
    }

    // 调试日志
    // console.log('当前数据源:', SKUResult ? 'SKUResult' : 'goods_sku_all_json');
    // console.log('有效价格:', prices);
}

/**
 * 从数组中生成指定长度的组合
 * 方法: 先生成[0,1...]形式的数组, 然后根据0,1从原数组取元素，得到组合数组
 */
function combInArray(aData) {
    if(!aData || !aData.length) {
        return [];
    }
    var len = aData.length;
    var aResult = [];
    for(var n = 1; n < len; n++) {
        var aaFlags = getCombFlags(len, n);
        while(aaFlags.length) {
            var aFlag = aaFlags.shift();
            var aComb = [];
            for(var i = 0; i < len; i++) {
                aFlag[i] && aComb.push(aData[i]);
            }
            aResult.push(aComb);
        }
    }
    return aResult;
}


/**
 * 得到从 m 元素中取 n 元素的所有组合
 * 结果为[0,1...]形式的数组, 1表示选中，0表示不选
 */
function getCombFlags(m, n) {
    if(!n || n < 1) {
        return [];
    }
    var aResult = [];
    var aFlag = [];
    var bNext = true;
    var i, j, iCnt1;
    for (i = 0; i < m; i++) {
        aFlag[i] = i < n ? 1 : 0;
    }
    aResult.push(aFlag.concat());
    while (bNext) {
        iCnt1 = 0;
        for (i = 0; i < m - 1; i++) {
            if (aFlag[i] == 1 && aFlag[i+1] == 0) {
                for(j = 0; j < i; j++) {
                    aFlag[j] = j < iCnt1 ? 1 : 0;
                }
                aFlag[i] = 0;
                aFlag[i+1] = 1;
                var aTmp = aFlag.concat();
                aResult.push(aTmp);
                if(aTmp.slice(-n).join("").indexOf('0') == -1) {
                    bNext = false;
                }
                break;
            }
            aFlag[i] == 1 && iCnt1++;
        }
    }
    return aResult;
}

function sortSelectedIds(keys, selectedIds) {
    // 将keys中的所有元素展平为一个数组
    var flatKeys = keys.flat();
    // 将selectedIds转换为字符串数组，以便与flatKeys进行比较
    var selectedIdsStr = selectedIds.map(String);
    // 按照flatKeys的顺序对selectedIdsStr进行排序
    selectedIdsStr.sort(function(a, b) {
        return flatKeys.indexOf(a) - flatKeys.indexOf(b);
    });
    // 将排序后的字符串数组转换回数字数组
    return selectedIdsStr.map(Number);
}




function initDisabled(){
    $('.sku').each(function() {
        var $sku = $(this);
        var sku_value_id = $sku.attr('sku_value_id');
        if (!SKUResult[sku_value_id]) {
            $sku.attr('disabled', 'disabled');
        }
    });
}

function clickSku(self) {
    //已经选择的节点
    var selectedObjs = $('.bh-sku-selected');
    if (selectedObjs.length) {
        //获得组合key价格
        var selectedIds = [];
        selectedObjs.each(function () {
            selectedIds.push($(this).attr('sku_value_id'));
        });
        selectedIds.sort(function (value1, value2) {
            return parseInt(value1) - parseInt(value2);
        });
        var len = selectedIds.length;
        var prices = SKUResult[selectedIds.join('-')].prices;
        var maxPrice = Math.max.apply(Math, prices);
        var minPrice = Math.min.apply(Math, prices);
        // $('#price').text(maxPrice > minPrice ? minPrice + "-" + maxPrice : maxPrice);
        if (maxPrice > minPrice) {
            $('#price').html(minPrice + `<span class="currency" style="margin-left: 3px;">起</span>`);
        } else {
            $('#price').html(maxPrice)
        }

        // 获取当前选择 SKU 的库存数量

        var currentStock = SKUResult[selectedIds.join('-')].stock;
        console.log('当前库存：' + currentStock)
        // 假设你有一个元素用于显示库存数量，这里以 #stock 为例
        $('#stock').text(currentStock);

        //用已选中的节点验证待测试节点 underTestObjs
        $(".sku").not(selectedObjs).not(self).each(function () {
            var siblingsSelectedObj = $(this).siblings('.bh-sku-selected');
            var testAttrIds = []; //从选中节点中去掉选中的兄弟节点
            if (siblingsSelectedObj.length) {
                var siblingsSelectedObjId = siblingsSelectedObj.attr('sku_value_id');
                for (var i = 0; i < len; i++) {
                    (selectedIds[i] != siblingsSelectedObjId) && testAttrIds.push(selectedIds[i]);
                }
            } else {
                testAttrIds = selectedIds.concat();
            }
            testAttrIds = testAttrIds.concat($(this).attr('sku_value_id'));
            testAttrIds.sort(function (value1, value2) {
                return parseInt(value1) - parseInt(value2);
            });
            if (!SKUResult[testAttrIds.join('-')]) {
                $(this).attr('disabled', 'disabled').removeClass('bh-sku-selected');
            } else {
                $(this).removeAttr('disabled');
            }
        });
        if (selectedIds.length == keys.length) {
            $('#select-sku-status').val(1)
        } else {
            $('#select-sku-status').val(0)
        }
        selectedIds = sortSelectedIds(keys, selectedIds);
        selectedIds = selectedIds.join('-');

        $('#sku-input').val(selectedIds)
    } else {
        //设置默认价格
        $('#price').text('--');
        // 设置默认库存数量，这里假设 totalStock 是获取全部库存的变量或方法
        var totalStock = getTotalStock(); // 这里需要你实现获取全部库存的逻辑
        $('#stock').text(totalStock || '--');
        //设置属性状态
        $('.sku').each(function () {
            SKUResult[$(this).attr('sku_value_id')]? $(this).removeAttr('disabled') : $(this).attr('disabled', 'disabled').removeClass('bh-sku-selected');
        })
        initPrices()
    }
}

// 获取全部库存的方法
// 获取全部库存的方法
function getTotalStock() {
    let hasCombinedSKU = false;
    let total = 0; // 确保初始化为数字0

    // 检查是否存在组合形式的 SKU
    for (let key in SKUResult) {
        if (SKUResult.hasOwnProperty(key) && key.includes('-')) {
            hasCombinedSKU = true;
            break;
        }
    }

    // 根据是否存在组合 SKU 来统计库存
    for (let key in SKUResult) {
        if (SKUResult.hasOwnProperty(key)) {
            // 确保stock值是数字类型
            const stock = Number(SKUResult[key].stock);

            if (hasCombinedSKU) {
                if (key.includes('-')) {
                    total += Number(stock); // 现在是数字相加
                }
            } else {
                total += Number(stock); // 现在是数字相加
            }
        }
    }

    return total;
}




//初始化用户选择事件
$(function() {
    initSKU();
    initPrices();
    initDisabled();
    $("body").on("click", ".sku", function(){


        if($(this).attr('disabled')){
            return false;
        }

        var self = $(this);
        //选中自己，兄弟节点取消选中
        self.toggleClass('bh-sku-selected').siblings().removeClass('bh-sku-selected');



        clickSku(self);
    })

});