<?php
/**
 * The productf management
 *
 * @package EMLOG
 * @link https://www.emlog.net
 */

/**
 * @var string $action
 * @var object $CACHE
 */

//require_once 'globals.php';
require_once '../init.php';

$orderModel = new Order_Model();
$Sort_Model = new Sort_Model();
$User_Model = new User_Model();
$MediaSort_Model = new MediaSort_Model();
$Template_Model = new Template_Model();

$sta_cache = $CACHE->readCache('sta');
$user_cache = $CACHE->readCache('user');
$action = Input::getStrVar('action');

// 订单列表
if (empty($action)) {

    if(isset($user_cache[UID]['role'])){
        $role = $user_cache[UID]['role'];
        $role_name = User::getRoleName($role, UID);
    }
    loginAuth::checkLogin(NULL, 'user');
    User::checkRolePermission();


    $tab = 'member';

    $page = Input::getIntVar('page', 1);
    $orderNum = $orderModel->getUserOrderNum();
    $order = $orderModel->getUserOrderForHome($page);
    $sorts = $CACHE->readCache('sort');

//    d($order);die;

    $subPage = '';
    foreach ($_GET as $key => $val) {
        $subPage .= $key != 'page' ? "&$key=$val" : '';
    }
    $pageurl = pagination($orderNum, Option::get('admin_article_perpage_num'), $page, "order.php?{$subPage}&page=");


    $mode_payment = getPayment();

//    d($mode_payment); die;

    include View::getUserView('header');
    require_once View::getUserView('order');
    include View::getUserView('footer');
    View::output();
}
// 订单列表
if ($action == 'search') {

    $tab = 'search';

    $pwd = Input::getStrVar('pwd');
    if(empty($pwd)){
        include View::getUserView('header');
        require_once View::getUserView('order');
        include View::getUserView('footer');
        View::output();
    }

    $page = Input::getIntVar('page', 1);
    $orderNum = $orderModel->getYoukeOrderNum($pwd);
    $order = $orderModel->getYoukeOrderForHome($page, $pwd);


    $subPage = '';
    foreach ($_GET as $key => $val) {
        $subPage .= $key != 'page' ? "&$key=$val" : '';
    }
    $pageurl = pagination($orderNum, Option::get('admin_article_perpage_num'), $page, "order.php?{$subPage}&page=");


    $GLOBALS['mode_payment'] = [];
    doAction('mode_payment');

    if(isset($GLOBALS['mode_payment'][0])){
        $GLOBALS['mode_payment'][0]['active'] = true;
    }

    $mode_payment = $GLOBALS['mode_payment'];

//    d($mode_payment); die;

    include View::getUserView('header');
    require_once View::getUserView('order');
    include View::getUserView('footer');
    View::output();
}

if($action == 'download'){
    $db = Database::getInstance();
    $id = Input::getIntVar('order_list_id'); // 子订单ID
    $sql = "SELECT * from " . DB_PREFIX . "deliver WHERE order_list_id={$id} order by id asc";
    $res = $db->query($sql);

    $content = "";

    while ($row = $db->fetch_array($res)) {
        $content .= $row['content'] . "\r\n";
    }
    $date = date('YmdHis');
    $filename = '卡密-' . $date . '.txt';

    // 设置HTTP头
    header('Content-Type: text/plain');
    header('Content-Disposition: attachment; filename="' . $filename . '"');
    header('Content-Length: ' . strlen($content));


    // 输出内容
    echo $content;
    exit;

}

// 查看卡密
if($action == 'sdk'){

    $db = Database::getInstance();

    $id = Input::getIntVar('id'); // 子订单ID

    $sql = "select count(id) total from " . DB_PREFIX . "deliver where order_list_id={$id}";
    $res = $db->once_fetch_array($sql);
    $total = $res['total'];

    $sql = "SELECT * from " . DB_PREFIX . "deliver WHERE order_list_id={$id} limit 500";
    $res = $db->query($sql);
    $data = [];
    while ($row = $db->fetch_array($res)) {
        $data['sdk'][] = $row;
        $data['order_id'] = empty($data['order_id']) ? $row['order_id'] : $data['order_id'];
    }
    $sql = "SELECT * FROM `" . DB_PREFIX . "order_list` WHERE `id` = {$id} LIMIT 1";
    $order_list = $db->once_fetch_array($sql);
    $goods_id = $order_list['goods_id'];
    $sql = "SELECT * FROM `" . DB_PREFIX . "goods` WHERE `id` = {$goods_id} LIMIT 1";
    $goods = $db->once_fetch_array($sql);
//    d($goods);die;




//    d($data);die;

    $out_trade_no = Input::getStrVar('out_trade_no');

    $order = $orderModel->getOrderInfo($out_trade_no);



    $order_id = $data['order_id'];
    if($order_id != $order['id']){
        emMsg('非法请求！');
    }

    $data = $data['sdk'];



    include View::getUserView('header');
    require_once View::getUserView('sdk');
    include View::getUserView('footer');
    View::output();

}

